/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.filters;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEffectFilter
extends AbstractFilter {
    protected boolean inverted = false;

    public AbstractEffectFilter(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public String getBookDescription() {
        return "Stops the spell from resolving unless it targets " + this.getDescriptionSegment();
    }

    abstract String getDescriptionSegment();

    public AbstractEffectFilter inverted() {
        this.inverted = !this.inverted;
        return this;
    }

    public boolean shouldAffect(HitResult rayTraceResult, Level level) {
        return this.inverted != super.shouldAffect(rayTraceResult, level);
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!this.shouldAffect(rayTraceResult, world)) {
            spellContext.setCanceled(true);
        }
    }

    public Integer getTypeIndex() {
        return 15;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public int getDefaultManaCost() {
        return 0;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return Collections.emptySet();
    }

    public boolean shouldResolveOnBlock(BlockHitResult target, Level level) {
        return false;
    }

    public boolean shouldResolveOnEntity(EntityHitResult target, Level level) {
        return false;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "Not Enough Glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

