/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class DurabilityBonus
extends GemBonus {
    public static Codec<DurabilityBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DurabilityBonus.gemClass(), (App)Purity.mapCodec(Codec.floatRange((float)0.0f, (float)1.0f)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, DurabilityBonus::new));
    protected final Map<Purity, Float> values;

    public DurabilityBonus(GemClass gemClass, Map<Purity, Float> values) {
        super(gemClass);
        this.values = values;
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        float level = this.values.get(gem.purity()).floatValue();
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(100.0f * level)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public float getDurabilityBonusPercentage(GemInstance gem) {
        return this.values.get(gem.purity()).floatValue();
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, Float> values = new HashMap<Purity, Float>();

        public Builder value(Purity purity, float value) {
            if (value < 0.0f || value > 1.0f) {
                throw new IllegalArgumentException("Durability bonus values must be between 0 and 1.");
            }
            this.values.put(purity, Float.valueOf(value));
            return this;
        }

        @Override
        public DurabilityBonus build(GemClass gClass) {
            return new DurabilityBonus(gClass, this.values);
        }
    }
}

