/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class SupportingEntity {
    public static Codec<SupportingEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(t -> t.entity), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(t -> Optional.ofNullable(t.nbt)), (App)Codec.DOUBLE.optionalFieldOf("x", (Object)0.0).forGetter(t -> t.x), (App)Codec.DOUBLE.optionalFieldOf("y", (Object)0.0).forGetter(t -> t.y), (App)Codec.DOUBLE.optionalFieldOf("z", (Object)0.0).forGetter(t -> t.z)).apply((Applicative)inst, SupportingEntity::new));
    public final EntityType<?> entity;
    protected final CompoundTag nbt;
    protected final double x;
    protected final double y;
    protected final double z;

    public SupportingEntity(EntityType<?> entity, Optional<CompoundTag> nbt, double x, double y, double z) {
        this.entity = entity;
        this.nbt = nbt.orElse(null);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Mob create(Level level, double x, double y, double z) {
        Mob ent = (Mob)this.entity.create(level);
        if (this.nbt != null) {
            ent.load(this.nbt);
        }
        ent.setPos(this.x + x, this.y + y, this.z + z);
        return ent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EntityType<? extends Mob> entity;
        private CompoundTag nbt;
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;

        public Builder entity(EntityType<? extends Mob> entity) {
            this.entity = entity;
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder nbt(Consumer<CompoundTag> nbt) {
            CompoundTag current = this.nbt == null ? new CompoundTag() : this.nbt;
            nbt.accept(current);
            this.nbt = current;
            return this;
        }

        public Builder x(double x) {
            this.x = x;
            return this;
        }

        public Builder y(double y) {
            this.y = y;
            return this;
        }

        public Builder z(double z) {
            this.z = z;
            return this;
        }

        public Builder position(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public SupportingEntity build() {
            if (this.entity == null) {
                throw new IllegalStateException("Entity type must be set");
            }
            return new SupportingEntity(this.entity, Optional.ofNullable(this.nbt), this.x, this.y, this.z);
        }
    }
}

