/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedFlowerPotBlockEntity;
import xfacthd.framedblocks.common.compat.amendments.AmendmentsCompat;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlowerPotBlock
extends FramedBlock {
    public FramedFlowerPotBlock() {
        super(BlockType.FRAMED_FLOWER_POT);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.HANGING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null && AmendmentsCompat.isLoaded()) {
            state = (BlockState)state.setValue((Property)PropertyHolder.HANGING, (Comparable)Boolean.valueOf(context.getClickedFace() == Direction.DOWN));
        }
        return state;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction side, BlockState sideState, LevelAccessor level, BlockPos pos, BlockPos sidePos) {
        if (((Boolean)state.getValue((Property)PropertyHolder.HANGING)).booleanValue() && side == Direction.UP && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, side, sideState, level, pos, sidePos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)PropertyHolder.HANGING)).booleanValue()) {
            return AmendmentsCompat.canSurviveHanging(level, pos.relative(Direction.UP));
        }
        return true;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hit);
        if (result.consumesAction() && result != ItemInteractionResult.CONSUME_PARTIAL) {
            return result;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedFlowerPotBlockEntity) {
            BlockItem item;
            boolean isFlower;
            FramedFlowerPotBlockEntity be = (FramedFlowerPotBlockEntity)blockEntity;
            Item item2 = stack.getItem();
            boolean bl = isFlower = item2 instanceof BlockItem && !FramedFlowerPotBlock.getFlowerPotState((item = (BlockItem)item2).getBlock()).isAir();
            if (isFlower != be.hasFlowerBlock()) {
                if (!level.isClientSide()) {
                    if (isFlower && !be.hasFlowerBlock()) {
                        be.setFlowerBlock(((BlockItem)stack.getItem()).getBlock());
                        player.awardStat(Stats.POT_FLOWER);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                    } else {
                        ItemStack flowerStack = new ItemStack((ItemLike)be.getFlowerBlock());
                        Utils.giveToPlayer(player, flowerStack, true);
                        be.setFlowerBlock(Blocks.AIR);
                    }
                }
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedFlowerPotBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }

    public static BlockState getFlowerPotState(Block flower) {
        Map fullPots = ((FlowerPotBlock)Blocks.FLOWER_POT).getFullPotsView();
        return fullPots.getOrDefault(BuiltInRegistries.BLOCK.getKey((Object)flower), () -> Blocks.AIR).get().defaultBlockState();
    }
}

