/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class CopycatStyleOverlay
extends BlockInteractOverlay {
    public static final Component LINE_USE_STANDARD = Utils.translate("tooltip", "copycat_style.use_standard");
    public static final Component LINE_USE_COPYCAT = Utils.translate("tooltip", "copycat_style.use_copycat");
    public static final Component LINE_SET_STANDARD = Utils.translate("tooltip", "copycat_style.set_standard");
    public static final Component LINE_SET_COPYCAT = Utils.translate("tooltip", "copycat_style.set_copycat");
    private static final List<Component> LINES_FALSE = List.of(LINE_USE_STANDARD, LINE_SET_COPYCAT);
    private static final List<Component> LINES_TRUE = List.of(LINE_USE_COPYCAT, LINE_SET_STANDARD);
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/copycat_style_symbols.png");
    private static final BlockInteractOverlay.Texture TEXTURE_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 22, 44, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 22, 22, 44, 22);

    public CopycatStyleOverlay() {
        super("copycat_style", LINES_FALSE, LINES_TRUE, TEXTURE_FALSE, TEXTURE_TRUE, ClientConfig.VIEW::getCopycatStyleMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.getItem() == FBContent.ITEM_FRAMED_HAMMER.value();
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        return target.state().hasProperty((Property)FramedProperties.COPYCAT_STYLE);
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        return (Boolean)target.state().getValue((Property)FramedProperties.COPYCAT_STYLE);
    }
}

