/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.data.outline.PrismOutlineRenderer;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class SlopedPrismOutlineRenderer
extends PrismOutlineRenderer {
    private static final Quaternionf[][] ZP_DIR = SlopedPrismOutlineRenderer.makeQuaternionArray();

    @Override
    public void drawCenterAndTriangle(PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        OutlineRenderer.drawLine(builder, pstack, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateMatrix(PoseStack pstack, BlockState state) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        Direction facing = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (Utils.isY(facing)) {
            if (orientation != Direction.SOUTH) {
                pstack.mulPose(YN_DIR[orientation.get2DDataValue()]);
            }
            if (facing == Direction.DOWN) {
                pstack.mulPose(Quaternions.ZP_180);
            }
        } else {
            if (facing != Direction.SOUTH) {
                pstack.mulPose(YN_DIR[facing.get2DDataValue()]);
            }
            if (orientation != Direction.DOWN) {
                pstack.mulPose(ZP_DIR[facing.get2DDataValue()][orientation.ordinal()]);
            }
            pstack.mulPose(Quaternions.XP_90);
        }
    }

    private static Quaternionf[][] makeQuaternionArray() {
        Quaternionf[][] array = new Quaternionf[4][6];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.get2DDataValue()] = new Quaternionf[6];
            for (Direction orientation : Direction.values()) {
                int mult = 2;
                if (orientation == dir.getCounterClockWise()) {
                    mult = 1;
                } else if (orientation == dir.getClockWise()) {
                    mult = 3;
                }
                array[dir.get2DDataValue()][orientation.ordinal()] = Axis.ZP.rotation(1.5707964f * (float)mult);
            }
        }
        return array;
    }
}

