/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class CommonShapes {
    public static final ShapeCache<Boolean> SLAB = ShapeCache.createIdentity(map -> {
        map.put(Boolean.FALSE, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
        map.put(Boolean.TRUE, Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    });
    public static final ShapeCache<Direction> PANEL = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });
    public static final ShapeCache<DirBoolKey> SLAB_EDGE = ShapeCache.create(map -> {
        VoxelShape shapeBot = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape shapeTop = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotationsWithFlag(shapeBot, shapeTop, Direction.NORTH, map, DirBoolKey::new);
    });
    public static final ShapeCache<Direction> CORNER_PILLAR = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });
    public static final ShapeCache<DirBoolKey> STRAIGHT_STAIRS = ShapeCache.create(map -> {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
        ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.SOUTH, map, DirBoolKey::new);
    });
    public static final ShapeCache<Direction> STRAIGHT_VERTICAL_STAIRS = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
        ShapeUtils.makeHorizontalRotations(shape, Direction.SOUTH, map);
    });
    public static final ShapeGenerator SLAB_GENERATOR = CommonShapes.createSlabGenerator(FramedProperties.TOP);
    public static final ShapeGenerator PANEL_GENERATOR = CommonShapes.createPanelGenerator(FramedProperties.FACING_HOR);

    public static ShapeGenerator createSlabGenerator(BooleanProperty topProp) {
        return states -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BlockState state : states) {
                builder.put((Object)state, (Object)SLAB.get((Boolean)state.getValue((Property)topProp)));
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        };
    }

    public static ShapeGenerator createPanelGenerator(DirectionProperty dirProp) {
        return states -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BlockState state : states) {
                Direction dir = (Direction)state.getValue((Property)dirProp);
                builder.put((Object)state, (Object)PANEL.get(dir));
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        };
    }

    public static ShapeGenerator createPanelGenerator(DirectionProperty dirProp, BooleanProperty invProp) {
        return states -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BlockState state : states) {
                Direction dir = (Direction)state.getValue((Property)dirProp);
                if (((Boolean)state.getValue((Property)invProp)).booleanValue()) {
                    dir = dir.getOpposite();
                }
                builder.put((Object)state, (Object)PANEL.get(dir));
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        };
    }

    private CommonShapes() {
    }

    public record DirBoolKey(Direction dir, boolean top) {
    }
}

