/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.permutated.pylons.util.Location;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="pylons")
public class SpawnManager {
    private static boolean dirty = false;
    private static Map<Location, Set<ResourceLocation>> chunkMap = new ConcurrentHashMap<Location, Set<ResourceLocation>>();
    private static final Map<Location, Pair<Set<Location>, Set<ResourceLocation>>> pylonMap = new ConcurrentHashMap<Location, Pair<Set<Location>, Set<ResourceLocation>>>();
    private static final List<MobSpawnType> blockedSpawnTypes = List.of(MobSpawnType.NATURAL, MobSpawnType.STRUCTURE);

    private SpawnManager() {
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (dirty) {
            ConcurrentHashMap<Location, Set<ResourceLocation>> replace = new ConcurrentHashMap<Location, Set<ResourceLocation>>();
            pylonMap.values().forEach(pair -> ((Set)pair.getLeft()).forEach(location -> replace.merge((Location)location, (Set)pair.getRight(), Sets::union)));
            chunkMap = replace;
            dirty = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)level;
                int chunkX = SectionPos.posToSectionCoord((double)entity.getX());
                int chunkZ = SectionPos.posToSectionCoord((double)entity.getZ());
                Location location = new Location((ResourceKey<Level>)level2.dimension(), BlockPos.ZERO, chunkX, chunkZ);
                Set<ResourceLocation> filterSet = chunkMap.get(location);
                if (filterSet == null) {
                    return;
                }
                ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType());
                if (filterSet.contains(key)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onMobSpawnEvent(MobSpawnEvent.SpawnPlacementCheck event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)serverLevelAccessor;
            if (blockedSpawnTypes.contains(event.getSpawnType())) {
                int chunkX = SectionPos.posToSectionCoord((double)event.getPos().getX());
                int chunkZ = SectionPos.posToSectionCoord((double)event.getPos().getZ());
                Location location = new Location((ResourceKey<Level>)level.dimension(), BlockPos.ZERO, chunkX, chunkZ);
                Set<ResourceLocation> filterSet = chunkMap.get(location);
                if (filterSet == null) {
                    return;
                }
                if (filterSet.isEmpty()) {
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
                }
            }
        }
    }

    public static void registerLifeless(ServerLevel level, BlockPos blockPos) {
        Location pylon = Location.of(level, blockPos);
        Range range = new Range(new byte[]{25});
        Set<Location> locations = Location.chunkSet(level, blockPos, range);
        pylonMap.put(pylon, (Pair<Set<Location>, Set<ResourceLocation>>)Pair.of(locations, Set.of()));
        dirty = true;
    }

    public static void register(ServerLevel level, BlockPos blockPos, Range range, Collection<ResourceLocation> filters) {
        if (filters.isEmpty()) {
            SpawnManager.unregister(level, blockPos);
            return;
        }
        Location pylon = Location.of(level, blockPos);
        Set<Location> locations = Location.chunkSet(level, blockPos, range);
        pylonMap.put(pylon, (Pair<Set<Location>, Set<ResourceLocation>>)Pair.of(locations, (Object)ImmutableSet.copyOf(filters)));
        dirty = true;
    }

    public static void unregister(ServerLevel level, BlockPos blockPos) {
        Location pylon = Location.of(level, blockPos);
        pylonMap.remove(pylon);
        dirty = true;
    }
}

