/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.harvester;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.machines.harvester.HarvesterPylonBlock;
import net.permutated.pylons.recipe.HarvestingRecipe;

public class HarvesterPylonTile
extends AbstractPylonTile {
    Status workStatus = Status.NONE;
    protected BlockCapabilityCache<IItemHandler, Direction> outputCache;

    public HarvesterPylonTile(BlockPos pos, BlockState state) {
        super(ModRegistry.HARVESTER_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{3, 5, 7, 9};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.getItem() instanceof HoeItem && !stack.is(ModRegistry.HARVESTER_BANNED);
    }

    @Override
    protected boolean canAccessInventory() {
        return ConfigManager.SERVER.harvesterCanBeAutomated.getAsBoolean();
    }

    @Override
    protected boolean canAccessEnergy() {
        return ConfigManager.SERVER.harvesterRequiresPower.getAsBoolean();
    }

    private boolean requiresTool() {
        return !HarvesterPylonTile.requiresPower() && ConfigManager.SERVER.harvesterRequiresTool.getAsBoolean();
    }

    public static boolean requiresPower() {
        return ConfigManager.SERVER.harvesterRequiresPower.getAsBoolean();
    }

    private int getPowerCost() {
        return ConfigManager.SERVER.harvesterPowerCost.getAsInt();
    }

    private int getWorkDelay() {
        return (Integer)ConfigManager.SERVER.harvesterWorkDelay.get();
    }

    @Override
    public void removeChunkloads() {
    }

    @Override
    public void updateContainer(FriendlyByteBuf packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.writeEnum((Enum)this.workStatus);
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getWorkDelay())) {
                boolean waterlogged;
                IItemHandler itemHandler;
                BlockPos above = this.getBlockPos().above();
                BlockEntity target = this.level.getBlockEntity(above);
                if (target == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                if (this.outputCache == null) {
                    this.outputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)above, (Object)Direction.DOWN);
                }
                if ((itemHandler = (IItemHandler)this.outputCache.getCapability()) == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                int hoeSlot = -1;
                if (this.requiresTool()) {
                    for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                        if (!this.isItemValid(this.itemStackHandler.getStackInSlot(i))) continue;
                        hoeSlot = i;
                        break;
                    }
                    if (hoeSlot == -1) {
                        this.workStatus = Status.MISSING_TOOL;
                        return;
                    }
                }
                int workY = (waterlogged = ((Boolean)this.getBlockState().getValue((Property)HarvesterPylonBlock.WATERLOGGED)).booleanValue()) ? above.getY() : this.getBlockPos().getY();
                int radius = (this.range.get() - 1) / 2;
                int minX = above.getX() - radius;
                int minZ = above.getZ() - radius;
                int maxX = above.getX() + radius;
                int maxZ = above.getZ() + radius;
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        HarvestingRecipe recipe;
                        int age;
                        ItemStack replace;
                        BlockPos workPos = new BlockPos(x, workY, z);
                        if (!this.level.isLoaded(workPos)) continue;
                        BlockState blockState = this.level.getBlockState(workPos);
                        Block block = blockState.getBlock();
                        if (block instanceof CropBlock) {
                            CropBlock crop = (CropBlock)block;
                            int currentAge = crop.getAge(blockState);
                            int maxAge = crop.getMaxAge();
                            if (0 == maxAge || currentAge < maxAge) continue;
                            if (HarvesterPylonTile.requiresPower()) {
                                if (!this.energyStorage.consumeEnergy(this.getPowerCost(), true)) {
                                    this.workStatus = Status.MISSING_ENERGY;
                                    return;
                                }
                                this.energyStorage.consumeEnergy(this.getPowerCost(), false);
                            } else if (this.requiresTool()) {
                                if (hoeSlot == -1) {
                                    this.workStatus = Status.MISSING_TOOL;
                                    return;
                                }
                                replace = this.itemStackHandler.getStackInSlot(hoeSlot).copy();
                                replace.hurtAndBreak(1, serverLevel, null, item -> {});
                                this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                            }
                            ItemStack seedStack = crop.getCloneItemStack((LevelReader)this.level, workPos, blockState);
                            List drops = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)workPos, null);
                            BlockState modified = crop.getStateForAge(0);
                            boolean updated = this.level.setBlockAndUpdate(workPos, modified);
                            if (!updated) {
                                this.workStatus = Status.UPDATE_ERROR;
                                Pylons.LOGGER.error("Failed to reset crop age for position: {}", (Object)workPos);
                                return;
                            }
                            for (ItemStack drop : drops) {
                                boolean result;
                                if (!seedStack.isEmpty() && drop.getItem() == seedStack.getItem()) {
                                    drop.shrink(1);
                                }
                                if (drop.isEmpty() || (result = this.insertItemOrDiscard(itemHandler, drop))) continue;
                                this.workStatus = Status.INVENTORY_FULL;
                                return;
                            }
                            continue;
                        }
                        Optional<HarvestingRecipe> optionalRecipe = ModRegistry.HARVESTING_REGISTRY.findRecipe(blockState.getBlock());
                        if (!optionalRecipe.isPresent() || (age = ((Integer)blockState.getValue((Property)(recipe = optionalRecipe.get()).getAgeProperty())).intValue()) <= recipe.getMinAge() || age != recipe.getMaxAge()) continue;
                        if (HarvesterPylonTile.requiresPower()) {
                            if (!this.energyStorage.consumeEnergy(this.getPowerCost(), true)) {
                                this.workStatus = Status.MISSING_ENERGY;
                                return;
                            }
                            this.energyStorage.consumeEnergy(this.getPowerCost(), false);
                        } else if (this.requiresTool()) {
                            if (hoeSlot == -1) {
                                this.workStatus = Status.MISSING_TOOL;
                                return;
                            }
                            replace = this.itemStackHandler.getStackInSlot(hoeSlot).copy();
                            replace.hurtAndBreak(1, serverLevel, null, item -> {});
                            this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                        }
                        ItemStack stack = recipe.getOutput().copy();
                        int harvestAge = recipe.getMaxAge() > 1 ? 1 : 0;
                        this.level.setBlock(workPos, (BlockState)blockState.setValue((Property)recipe.getAgeProperty(), (Comparable)Integer.valueOf(harvestAge)), 2);
                        boolean result = this.insertItemOrDiscard(itemHandler, stack);
                        if (result) continue;
                        this.workStatus = Status.INVENTORY_FULL;
                        return;
                    }
                }
                this.workStatus = Status.WORKING;
            }
        }
    }

    private boolean insertItemOrDiscard(IItemHandler itemHandler, ItemStack itemStack) {
        ItemStack progress = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack, (boolean)false);
        return progress.isEmpty();
    }

    public static enum Status {
        NONE,
        WORKING,
        MISSING_TOOL,
        MISSING_INVENTORY,
        INVENTORY_FULL,
        UPDATE_ERROR,
        MISSING_ENERGY;

    }
}

