/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.base;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.compat.dye.DyeCompat;
import net.permutated.pylons.machines.base.AbstractPylonContainer;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.TranslationKey;

public abstract class AbstractPylonBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    protected AbstractPylonBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(-1.0f, 1200.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.TRUE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENABLED});
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public abstract IContainerFactory<AbstractPylonContainer> containerFactory();

    public abstract BlockEntityType<? extends AbstractPylonTile> getTileType();

    public static boolean canAccessPylon(@Nullable BlockEntity blockEntity, Player player) {
        AbstractPylonTile tile;
        return blockEntity instanceof AbstractPylonTile && (tile = (AbstractPylonTile)blockEntity).canAccess(player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == this.getTileType() ? AbstractPylonTile::tick : null;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        BlockEntity tileEntity;
        if (!level.isClientSide && entity instanceof Player && !(entity instanceof FakePlayer) && (tileEntity = level.getBlockEntity(blockPos)) instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            pylonTile.setOwner(entity.getUUID());
        }
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)blockEntity;
            pylonTile.removeChunkloads();
            pylonTile.dropItems();
        }
        super.destroy(world, blockPos, blockState);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos blockPos) {
        BlockEntity blockEntity = getter.getBlockEntity(blockPos);
        if (AbstractPylonBlock.canAccessPylon(blockEntity, player)) {
            int i = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)getter, (BlockPos)blockPos) ? 30 : 100;
            return player.getDigSpeed(state, blockPos) / 2.0f / (float)i;
        }
        return 0.0f;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)blockEntity;
                pylonTile.removeChunkloads();
                pylonTile.dropItems();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.hasNeighborSignal(pos);
        if (!Boolean.valueOf(flag).equals(state.getValue((Property)ENABLED))) {
            BlockEntity blockEntity;
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 3);
            if (!flag && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)blockEntity;
                pylonTile.removeChunkloads();
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        AbstractPylonTile pylonTile;
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (stack.is(Tags.Items.DYES) && level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof AbstractPylonTile && AbstractPylonBlock.canAccessPylon(pylonTile = (AbstractPylonTile)blockEntity, player)) {
            int color = DyeCompat.getColor(stack);
            if (color == DyeColor.WHITE.getTextureDiffuseColor()) {
                color = -1;
            }
            pylonTile.setColor(color);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, final Player player, BlockHitResult blockRayTraceResult) {
        if (world.isClientSide) return InteractionResult.SUCCESS;
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof AbstractPylonTile) {
            final AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)AbstractPylonBlock.this.getDescriptionId());
                }

                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess(), ConnectionType.NEOFORGE);
                    pylonTile.updateContainer((FriendlyByteBuf)buffer);
                    return AbstractPylonBlock.this.containerFactory().create(i, playerInventory, buffer);
                }
            };
            if (!AbstractPylonBlock.canAccessPylon(tileEntity, player)) return InteractionResult.FAIL;
            player.openMenu(containerProvider, pylonTile::updateContainer);
            return InteractionResult.SUCCESS;
        } else {
            Pylons.LOGGER.error("tile entity not instance of AbstractPylonTile");
            return InteractionResult.FAIL;
        }
    }

    protected MutableComponent translate(String key) {
        return Component.translatable((String)TranslationKey.tooltip(key)).withStyle(ChatFormatting.GRAY);
    }
}

