/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.BlockComponent;
import net.permutated.pylons.util.TranslationKey;

public class BlockFilterCard
extends Item {
    public BlockFilterCard() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        ServerLevel level;
        BlockState blockState;
        Level level2;
        if (context.getItemInHand().getItem() instanceof BlockFilterCard && (level2 = context.getLevel()) instanceof ServerLevel && !(blockState = (level = (ServerLevel)level2).getBlockState(clickedPos = context.getClickedPos())).isAir()) {
            Block block = blockState.getBlock();
            ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
            String name = block.getDescriptionId();
            context.getItemInHand().set(ModRegistry.BLOCK_COMPONENT, (Object)new BlockComponent(key, name));
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.getComponents().has(ModRegistry.BLOCK_COMPONENT.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        BlockComponent component = (BlockComponent)stack.get(ModRegistry.BLOCK_COMPONENT);
        if (component != null) {
            String name = component.descriptionId();
            tooltip.add((Component)Component.translatable((String)name).withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)this.translate("insert1"));
            tooltip.add((Component)this.translate("insert2"));
        } else {
            tooltip.add((Component)this.translate("no_block"));
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)this.translate("protection"));
    }

    protected MutableComponent translate(String key) {
        return Component.translatable((String)TranslationKey.tooltip(key)).withStyle(ChatFormatting.GRAY);
    }

    protected MutableComponent translate(String key, Object ... values) {
        return Component.translatable((String)TranslationKey.tooltip(key), (Object[])values);
    }
}

