/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters.client;

import com.matyrobbrt.mekanisticrouters.MekRouters;
import com.matyrobbrt.mekanisticrouters.item.ChemicalSettings;
import java.util.ArrayList;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.logic.settings.TransferDirection;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.Range;

public class ChemicalModuleScreen
extends ModuleScreen {
    static final XYPoint LARGE_TEXTFIELD_XY = new XYPoint(0, 212);
    private final ItemStack routerStack = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private final ItemStack tankStack = new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK.asItem());
    private final ItemStack gaugeDropperStack = new ItemStack((ItemLike)MekanismItems.GAUGE_DROPPER.asItem());
    private IntegerTextField maxTransferField;
    private FluidDirectionButton fluidDir;
    private RegulateAbsoluteButton regulationTypeButton;

    public ChemicalModuleScreen(ModuleMenu container, Inventory inventory, Component displayName) {
        super(container, inventory, displayName);
    }

    public void init() {
        super.init();
        ChemicalSettings settings = (ChemicalSettings)this.moduleItemStack.getOrDefault(MekRouters.CHEMICAL_SETTINGS, (Object)ChemicalSettings.DEFAULT);
        this.maxTransferField = new IntegerTextField(this.font, this.leftPos + 152, this.topPos + 23, 34, 12, Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        if (settings.maxTransfer() > 0) {
            this.maxTransferField.setValue(settings.maxTransfer());
        }
        this.maxTransferField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.maxTransferField.setIncr(100, 10, 10);
        this.maxTransferField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.maxTransferField);
        this.addRenderableWidget((GuiEventListener)new TooltipButton(this.leftPos + 130, this.topPos + 19, 16, 16, this.gaugeDropperStack));
        this.fluidDir = new FluidDirectionButton(this, this.leftPos + 148, this.topPos + 44, settings.direction());
        this.addRenderableWidget((GuiEventListener)this.fluidDir);
        this.regulationTypeButton = new RegulateAbsoluteButton(this.regulatorTextField.getX() + this.regulatorTextField.getWidth() + 2, this.regulatorTextField.getY() - 1, 18, 14, b -> this.toggleRegulationType(), settings.regulateAbsolute());
        this.addRenderableWidget((GuiEventListener)this.regulationTypeButton);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 17, this.leftPos + 183, this.topPos + 35, "mekanisticrouters.guiText.popup.chemical.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 126, this.topPos + 42, this.leftPos + 185, this.topPos + 61, "mekanisticrouters.guiText.popup.chemical.direction");
    }

    protected IntegerTextField buildRegulationTextField() {
        IntegerTextField tf = new IntegerTextField(this.font, this.leftPos + 128, this.topPos + 90, 40, 12, Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        tf.setValue(this.getRegulatorAmount());
        tf.setResponder(str -> {
            this.setRegulatorAmount(str.isEmpty() ? 0 : Integer.parseInt(str));
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(GUI_TEXTURE, this.leftPos + 146, this.topPos + 20, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
        graphics.renderItem(this.routerStack, this.leftPos + 128, this.topPos + 44);
        graphics.renderItem(this.tankStack, this.leftPos + 168, this.topPos + 44);
    }

    public void containerTick() {
        super.containerTick();
        this.regulationTypeButton.visible = this.regulatorTextField.visible;
        this.regulationTypeButton.setText();
        this.regulatorTextField.setRange(Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.regulationTypeButton.regulateAbsolute ? Integer.MAX_VALUE : 100)));
    }

    protected void buildComponentPatch(DataComponentPatch.Builder builder) {
        builder.set((DataComponentType)MekRouters.CHEMICAL_SETTINGS.get(), (Object)new ChemicalSettings((TransferDirection)this.fluidDir.getState(), this.maxTransferField.getIntValue(), this.regulationTypeButton.regulateAbsolute));
    }

    private void toggleRegulationType() {
        this.regulationTypeButton.toggle();
        this.regulatorTextField.setRange(this.regulationTypeButton.regulateAbsolute ? Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        this.sendToServer();
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(ClientUtil.xlate((String)"mekanisticrouters.guiText.tooltip.chemicalTransferTooltip", (Object[])new Object[0]));
            tooltip.add(Component.empty());
            tooltip.add(ClientUtil.xlate((String)"modularrouters.guiText.tooltip.numberFieldTooltip", (Object[])new Object[0]));
            ClientUtil.setMultilineTooltip((AbstractWidget)this, tooltip);
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }

    private class FluidDirectionButton
    extends TexturedCyclerButton<TransferDirection> {
        FluidDirectionButton(ChemicalModuleScreen chemicalModuleScreen, int x, int y, TransferDirection initialVal) {
            super(x, y, 16, 16, (Enum)initialVal, (ISendToServer)chemicalModuleScreen);
        }

        protected XYPoint getTextureXY() {
            return new XYPoint(160 + ((TransferDirection)this.getState()).ordinal() * 16, 16);
        }
    }

    private static class RegulateAbsoluteButton
    extends ExtendedButton {
        private boolean regulateAbsolute;

        public RegulateAbsoluteButton(int xPos, int yPos, int width, int height, Button.OnPress pressable, boolean regulateAbsolute) {
            super(xPos, yPos, width, height, (Component)Component.empty(), pressable);
            this.regulateAbsolute = regulateAbsolute;
        }

        private void toggle() {
            this.regulateAbsolute = !this.regulateAbsolute;
        }

        void setText() {
            this.setMessage((Component)Component.literal((String)(this.regulateAbsolute ? "mB" : "%")));
        }
    }
}

