/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters;

import com.matyrobbrt.mekanisticrouters.MRConfig;
import com.matyrobbrt.mekanisticrouters.data.MRItemModelProvider;
import com.matyrobbrt.mekanisticrouters.data.MRRecipesProvider;
import com.matyrobbrt.mekanisticrouters.item.ChemicalModule1;
import com.matyrobbrt.mekanisticrouters.item.ChemicalModule2;
import com.matyrobbrt.mekanisticrouters.item.ChemicalRefillModule;
import com.matyrobbrt.mekanisticrouters.item.ChemicalSettings;
import com.matyrobbrt.mekanisticrouters.item.ChemicalUpgrade;
import java.util.Optional;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModCreativeModeTabs;
import me.desht.modularrouters.core.ModItems;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="mekanisticrouters")
public final class MekRouters {
    public static final String MOD_ID = "mekanisticrouters";
    public static final ItemCapability<IChemicalHandler, Void> ITEM_CHEMICAL = ItemCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_handler"), IChemicalHandler.class);
    public static final BlockCapability<IChemicalHandler, Direction> BLOCK_CHEMICAL = BlockCapability.createSided((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_handler"), IChemicalHandler.class);
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"mekanisticrouters");
    public static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"mekanisticrouters");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"mekanisticrouters");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ChemicalSettings>> CHEMICAL_SETTINGS = COMPONENTS.registerComponentType("chemical_settings", b -> b.persistent(ChemicalSettings.CODEC).networkSynchronized(ChemicalSettings.STREAM_CODEC));
    public static final DeferredHolder<MenuType<?>, MenuType<ModuleMenu>> CHEMICAL_MODULE_MENU = MENU_TYPES.register("chemical_module", () -> IMenuTypeExtension.create(MekRouters::createChemicalMenu));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ChemicalRefillModule.RefillSettings>> REFILL_SETTINGS = COMPONENTS.registerComponentType("refill_settings", b -> b.persistent(ChemicalRefillModule.RefillSettings.CODEC).networkSynchronized(ChemicalRefillModule.RefillSettings.STREAM_CODEC));
    public static final DeferredHolder<MenuType<?>, MenuType<ModuleMenu>> CHEMICAL_REFILL_MODULE_MENU = MENU_TYPES.register("chemical_refill_module", () -> IMenuTypeExtension.create(MekRouters::createChemicalRefillMenu));
    public static final DeferredItem<ChemicalModule1> CHEMICAL_MODULE_1 = ITEMS.register("chemical_module_mk1", () -> new ChemicalModule1(ModItems.moduleProps()));
    public static final DeferredItem<ChemicalModule2> CHEMICAL_MODULE_2 = ITEMS.register("chemical_module_mk2", ChemicalModule2::new);
    public static final DeferredItem<ChemicalRefillModule> CHEMICAL_REFILL_MODULE = ITEMS.register("chemical_refill_module", ChemicalRefillModule::new);
    public static final DeferredItem<ChemicalUpgrade> CHEMICAL_UPGRADE = ITEMS.register("chemical_upgrade", ChemicalUpgrade::new);

    public MekRouters(IEventBus bus, ModContainer container) {
        ITEMS.register(bus);
        COMPONENTS.register(bus);
        MENU_TYPES.register(bus);
        bus.addListener(event -> {
            if (event.getTab() == ModCreativeModeTabs.DEFAULT.get()) {
                event.accept(CHEMICAL_UPGRADE);
                event.accept(CHEMICAL_MODULE_1);
                event.accept(CHEMICAL_MODULE_2);
                event.accept(CHEMICAL_REFILL_MODULE);
            }
        });
        bus.addListener(event -> {
            event.getGenerator().addProvider(event.includeClient(), (DataProvider)new MRItemModelProvider(event.getGenerator(), event.getExistingFileHelper()));
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)new MRRecipesProvider(event.getGenerator().getPackOutput(), event.getLookupProvider()));
        });
        bus.addListener(event -> event.registerBlockEntity(BLOCK_CHEMICAL, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get(), (object, context) -> (IChemicalHandler)object.getBufferCapability(ITEM_CHEMICAL)));
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MRConfig.SPEC);
    }

    public static Optional<ChemicalStack> getStoredChemical(ItemStack stack) {
        return Optional.ofNullable((IChemicalHandler)stack.getCapability(ITEM_CHEMICAL)).filter(h -> h.getChemicalTanks() > 0).map(h -> h.getChemicalInTank(0));
    }

    private static ModuleMenu createChemicalMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        return new ModuleMenu((MenuType)CHEMICAL_MODULE_MENU.get(), windowId, inv, extra);
    }

    private static ModuleMenu createChemicalRefillMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        return new ModuleMenu((MenuType)CHEMICAL_REFILL_MODULE_MENU.get(), windowId, inv, extra);
    }

    public static ChemicalStack tryChemicalTransfer(IChemicalHandler chemSource, IChemicalHandler chemDest, long maxAmount, boolean doTransfer) {
        ChemicalStack drainable = chemSource.extractChemical(maxAmount, Action.SIMULATE);
        if (!drainable.isEmpty()) {
            long fillableAmount = drainable.getAmount() - chemDest.insertChemical(drainable, Action.SIMULATE).getAmount();
            if (fillableAmount > 0L) {
                drainable.setAmount(fillableAmount);
                if (doTransfer) {
                    ChemicalStack drained = chemSource.extractChemical(drainable, Action.EXECUTE);
                    if (!drained.isEmpty()) {
                        drained.shrink(chemDest.insertChemical(drained, Action.EXECUTE).getAmount());
                        return drained;
                    }
                } else {
                    return drainable;
                }
            }
            return ChemicalStack.EMPTY;
        }
        return ChemicalStack.EMPTY;
    }
}

