/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.renderer.cosmetics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticAnchor;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetics;
import tech.thatgravyboat.creeperoverhaul.client.renderer.cosmetics.CosmeticRenderer;

public class CosmeticLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final CosmeticRenderer renderer = new CosmeticRenderer();

    public CosmeticLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack stack, MultiBufferSource source, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Cosmetic cosmetic = Cosmetics.getCosmetic(entity.getUUID());
        if (cosmetic == null || entity.isInvisible()) {
            return;
        }
        stack.pushPose();
        ModelPart part = switch (cosmetic.anchor()) {
            default -> throw new MatchException(null, null);
            case CosmeticAnchor.BODY -> ((PlayerModel)this.getParentModel()).body;
            case CosmeticAnchor.HEAD -> ((PlayerModel)this.getParentModel()).head;
            case CosmeticAnchor.LEFT_ARM -> ((PlayerModel)this.getParentModel()).leftArm;
            case CosmeticAnchor.RIGHT_ARM -> ((PlayerModel)this.getParentModel()).rightArm;
            case CosmeticAnchor.LEFT_LEG -> ((PlayerModel)this.getParentModel()).leftLeg;
            case CosmeticAnchor.RIGHT_LEG -> ((PlayerModel)this.getParentModel()).rightLeg;
        };
        part.translateAndRotate(stack);
        cosmetic.transformation().applyScale(stack);
        stack.mulPose(Axis.XN.rotationDegrees(180.0f));
        stack.mulPose(Axis.YN.rotationDegrees(180.0f));
        stack.translate(-0.5, -0.5, -0.5);
        cosmetic.transformation().applyTranslation(stack);
        cosmetic.transformation().applyRotation(stack);
        RenderType type = RenderType.entityTranslucent((ResourceLocation)cosmetic.texture().getResourceLocation());
        VertexConsumer consumer = source.getBuffer(type);
        CosmeticModel model = cosmetic.model();
        BakedGeoModel bakedModel = model.getBakedModel(null);
        if (model.isLoaded()) {
            this.renderer.setModel(model);
            AnimationState state = new AnimationState((GeoAnimatable)cosmetic, 0.0f, 0.0f, headPitch, true);
            model.setCustomAnimations(cosmetic, this.renderer.getInstanceId(cosmetic), state);
            this.renderer.reRender(bakedModel, stack, source, cosmetic, type, consumer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
        }
        stack.popPose();
    }
}

