/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenEntity;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassBaseData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassStateData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassTargetData;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ThronePillarBehavior {
    public static void applyFatigueAndSpawningBeeQueen(ServerPlayer serverPlayer) {
        ServerLevel level = (ServerLevel)serverPlayer.level();
        StructureManager structureManager = level.structureManager();
        StructureStart structureStart = structureManager.getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.BEE_QUEEN_MINING_FATIGUE);
        if (structureStart.isValid()) {
            boolean hasBeeQueenNearby;
            BlockPos structureCenter = structureStart.getBoundingBox().getCenter();
            boolean hasBeeQueenNearStructureCenter = !level.getEntitiesOfClass(BeeQueenEntity.class, AABB.ofSize((Vec3)structureCenter.getCenter(), (double)16.0, (double)16.0, (double)16.0), e -> !e.isNoAi()).isEmpty();
            boolean bl = hasBeeQueenNearby = hasBeeQueenNearStructureCenter || !level.getEntitiesOfClass(BeeQueenEntity.class, serverPlayer.getBoundingBox().inflate(30.0, 30.0, 30.0), e -> !e.isNoAi()).isEmpty();
            if (hasBeeQueenNearby && !serverPlayer.isCreative() && !serverPlayer.isSpectator() && !EssenceOfTheBees.hasEssence(serverPlayer)) {
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, 2, false, false, true));
            }
            if (!BzGeneralConfigs.beeQueenRespawning) {
                return;
            }
            ArrayList<ItemStack> throneCompasses = new ArrayList<ItemStack>();
            for (ItemStack item : serverPlayer.getInventory().items) {
                if (!item.is((Item)BzItems.HONEY_COMPASS.get())) continue;
                HoneyCompassBaseData honeyCompassBaseData = (HoneyCompassBaseData)item.get((DataComponentType)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
                HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)item.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
                HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)item.get((DataComponentType)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
                if (honeyCompassStateData.locatedSpecialStructure() || !honeyCompassBaseData.isStructureCompass() || !honeyCompassBaseData.customName().isPresent() || !honeyCompassBaseData.customName().get().equals("item.the_bumblezone.honey_compass_throne_structure") || !honeyCompassTargetData.targetPos().isPresent() || !honeyCompassTargetData.targetPos().get().above(128).closerThan((Vec3i)structureCenter, 128.0)) continue;
                throneCompasses.add(item);
            }
            if (!hasBeeQueenNearby && !throneCompasses.isEmpty()) {
                BeeQueenEntity newBeeQueen = (BeeQueenEntity)((EntityType)BzEntities.BEE_QUEEN.get()).create((Level)level);
                BlockPos queenPos = new BlockPos(structureCenter.getX(), 133, structureCenter.getZ());
                newBeeQueen.setPos(Vec3.atCenterOf((Vec3i)queenPos));
                newBeeQueen.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(newBeeQueen.blockPosition()), MobSpawnType.STRUCTURE, null);
                PlatformService.INSTANCE.finalizeSpawn((Mob)newBeeQueen, (ServerLevelAccessor)level, null, MobSpawnType.STRUCTURE);
                level.addFreshEntity((Entity)newBeeQueen);
                level.setBlock(queenPos.above(17), ((LiquidBlock)BzFluids.ROYAL_JELLY_FLUID_BLOCK.get()).defaultBlockState(), 3);
            }
            throneCompasses.forEach(compass -> {
                HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)compass.get((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
                compass.set((DataComponentType)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData(honeyCompassStateData.locked(), honeyCompassStateData.searchId(), honeyCompassStateData.isLoading(), honeyCompassStateData.isFailed(), true));
            });
        }
    }
}

