/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SempiternalSanctumBehavior {
    private static final HashSet<UUID> PLAYERS_IN_SANCTUMS = new HashSet();

    public static void runStructureMessagesAndFatigue(ServerPlayer serverPlayer) {
        StructureManager structureManager = ((ServerLevel)serverPlayer.level()).structureManager();
        StructureStart detectedStructure = structureManager.getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.SEMPITERNAL_SANCTUMS);
        if (detectedStructure.isValid()) {
            MobEffectInstance effect;
            if (EssenceOfTheBees.hasEssence(serverPlayer)) {
                if (!PLAYERS_IN_SANCTUMS.contains(serverPlayer.getUUID())) {
                    BlockPos structureCenter = detectedStructure.getBoundingBox().getCenter().below(20);
                    if (!serverPlayer.level().getBlockState(structureCenter).is(BzTags.ESSENCE_BLOCKS)) {
                        return;
                    }
                    PLAYERS_IN_SANCTUMS.add(serverPlayer.getUUID());
                    if (serverPlayer.tickCount > 40) {
                        ResourceLocation resourceLocation = ((Registry)serverPlayer.level().registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)detectedStructure.getStructure());
                        if (resourceLocation == null) {
                            return;
                        }
                        ChatFormatting color = resourceLocation.getPath().contains("_red") ? ChatFormatting.RED : (resourceLocation.getPath().contains("_yellow") ? ChatFormatting.YELLOW : (resourceLocation.getPath().contains("_green") ? ChatFormatting.GREEN : (resourceLocation.getPath().contains("_blue") ? ChatFormatting.BLUE : (resourceLocation.getPath().contains("_purple") ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.WHITE))));
                        MutableComponent message = Component.translatable((String)("system.the_bumblezone." + resourceLocation.getPath())).withStyle(ChatFormatting.BOLD).withStyle(color);
                        serverPlayer.displayClientMessage((Component)message, true);
                    }
                }
                ((GenericTrigger)((Object)BzCriterias.SEMPITERNAL_SANCTUM_ENTER_WITH_BEE_ESSENCE_TRIGGER.get())).trigger(serverPlayer);
            } else if (!(serverPlayer.isCreative() || serverPlayer.isSpectator() || (effect = serverPlayer.getEffect(MobEffects.DIG_SLOWDOWN)) != null && effect.getAmplifier() > 2)) {
                MutableComponent message = Component.translatable((String)"system.the_bumblezone.no_essence").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                serverPlayer.displayClientMessage((Component)message, true);
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 800, 3, false, false, true));
            }
            if (serverPlayer.tickCount % 60 == 20) {
                MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.SEMPITERNAL_SANCTUM.get()).getLocation(), true);
            }
        } else if (serverPlayer.tickCount % 60 == 20 && PLAYERS_IN_SANCTUMS.contains(serverPlayer.getUUID())) {
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.SEMPITERNAL_SANCTUM.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RADIANCE_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.LIFE_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CALMING_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.KNOWING_EVENT.get()).getLocation(), false);
            MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CONTINUITY_EVENT.get()).getLocation(), false);
            PLAYERS_IN_SANCTUMS.remove(serverPlayer.getUUID());
        }
    }

    public static void onArenaAreaDeath(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        block2: {
            EssenceBlockEntity essenceBlockEntity;
            BlockPos structureCenter;
            block4: {
                block3: {
                    StructureManager structureManager;
                    StructureStart detectedStructure;
                    if (!serverLevel.dimension().equals(BzDimension.BZ_WORLD_KEY) || !(detectedStructure = (structureManager = serverLevel.structureManager()).getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.SEMPITERNAL_SANCTUMS)).isValid()) break block2;
                    structureCenter = detectedStructure.getBoundingBox().getCenter().below(20);
                    BlockState blockState = serverLevel.getBlockState(structureCenter);
                    BlockEntity blockEntity = serverLevel.getBlockEntity(structureCenter);
                    if (!blockState.is(BzTags.ESSENCE_BLOCKS) || !(blockEntity instanceof EssenceBlockEntity)) break block3;
                    essenceBlockEntity = (EssenceBlockEntity)blockEntity;
                    if (AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)structureCenter), (double)(essenceBlockEntity.getArenaSize().getX() + 2), (double)(essenceBlockEntity.getArenaSize().getY() + 2), (double)(essenceBlockEntity.getArenaSize().getZ() + 2)).contains(Vec3.atCenterOf((Vec3i)serverPlayer.blockPosition()))) break block4;
                }
                return;
            }
            Direction directionOffset = Direction.Plane.HORIZONTAL.getRandomDirection(serverLevel.getRandom());
            int xOffset = (int)(((float)essenceBlockEntity.getArenaSize().getX() * 0.5f + 3.0f) * (float)directionOffset.getStepX());
            int zOffset = (int)(((float)essenceBlockEntity.getArenaSize().getZ() * 0.5f + 3.0f) * (float)directionOffset.getStepZ());
            Vec3 newPosition = Vec3.atCenterOf((Vec3i)structureCenter.offset(xOffset, -6, zOffset));
            serverPlayer.removeVehicle();
            serverPlayer.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            serverPlayer.setPos(newPosition);
            serverPlayer.setOldPosAndRot();
            serverPlayer.teleportTo(serverLevel, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), serverPlayer.getYRot(), serverPlayer.getXRot());
        }
    }
}

