/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RoofedDimensionCeilingPlacement
extends PlacementModifier {
    private final int maxHeight;
    public static final MapCodec<RoofedDimensionCeilingPlacement> CODEC = RecordCodecBuilder.mapCodec(configInstance -> configInstance.group((App)Codec.INT.fieldOf("max_height").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxHeight)).apply((Applicative)configInstance, RoofedDimensionCeilingPlacement::new));

    private RoofedDimensionCeilingPlacement(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BzPlacements.ROOFED_DIMENSION_CEILING_PLACEMENT.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        int minY = placementContext.generator().getMinY();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(blockPos.getX(), this.maxHeight, blockPos.getZ());
        while (mutable.getY() > minY) {
            BlockState state = placementContext.getBlockState((BlockPos)mutable);
            if (state.isAir()) {
                return Stream.of(mutable.immutable());
            }
            mutable.move(Direction.DOWN);
        }
        return Stream.of(new BlockPos[0]);
    }
}

