/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class Random3DUndergroundChunkPlacement
extends RepeatingPlacement {
    private final IntProvider count;
    public static final MapCodec<Random3DUndergroundChunkPlacement> CODEC = IntProvider.codec((int)0, (int)100000).fieldOf("count").xmap(Random3DUndergroundChunkPlacement::new, placement -> placement.count);

    private Random3DUndergroundChunkPlacement(IntProvider intProvider) {
        this.count = intProvider;
    }

    public static Random3DUndergroundChunkPlacement of(IntProvider intProvider) {
        return new Random3DUndergroundChunkPlacement(intProvider);
    }

    public static Random3DUndergroundChunkPlacement of(int i) {
        return Random3DUndergroundChunkPlacement.of((IntProvider)ConstantInt.of((int)i));
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BzPlacements.RANDOM_3D_UNDERGROUND_CHUNK_PLACEMENT.get();
    }

    protected int count(RandomSource random, BlockPos blockPos) {
        return this.count.sample(random);
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int chunkNum = 0; chunkNum <= this.count(random, blockPos); ++chunkNum) {
            int attempts;
            for (attempts = 0; attempts < 8; ++attempts) {
                mutableBlockPos.set(blockPos.getX(), 0, blockPos.getZ()).move(random.nextInt(4) + 8, random.nextInt(253) + 1, random.nextInt(4) + 8);
                if (placementContext.getBlockState((BlockPos)mutableBlockPos).getBlock() != Blocks.CAVE_AIR && !placementContext.getBlockState((BlockPos)mutableBlockPos).getFluidState().is(FluidTags.WATER)) continue;
                mutableBlockPos.set(blockPos.getX(), mutableBlockPos.getY(), blockPos.getZ());
                break;
            }
            if (attempts == 8) continue;
            for (int crystalcount = 0; crystalcount <= 180; ++crystalcount) {
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                int y = random.nextInt(16);
                blockPosList.add(mutableBlockPos.offset(x, y, z));
            }
        }
        return blockPosList.stream();
    }
}

