/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseGeneratorSettingsAccessor;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeInfluencedNoiseSampler;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeRegistryHolder;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BzBiomeSource;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.NoVerticalBlendBiomeManager;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.NoiseChunkExtension;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.apache.commons.lang3.mutable.MutableObject;

public class BzChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<BzChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final Holder<NoiseGeneratorSettings> settings;
    private final Aquifer.FluidPicker globalFluidPicker;

    public BzChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> supplier) {
        super(biomeSource, supplier);
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)supplier.value();
        this.defaultBlock = noiseGeneratorSettings.defaultBlock();
        this.defaultFluid = noiseGeneratorSettings.defaultFluid();
        NoiseRouter noiseRouter = noiseGeneratorSettings.noiseRouter();
        Climate.Sampler sampler = new Climate.Sampler(noiseRouter.temperature(), noiseRouter.vegetation(), noiseRouter.continents(), noiseRouter.erosion(), noiseRouter.depth(), noiseRouter.ridges(), noiseGeneratorSettings.spawnTarget());
        ((NoiseGeneratorSettingsAccessor)noiseGeneratorSettings).bumblezone$setNoiseRouter(noiseRouter.mapAll(densityFunction -> {
            if (densityFunction instanceof BiomeNoise) {
                return new BiomeNoise(() -> ((BzChunkGenerator)this).getBiomeSource(), () -> sampler);
            }
            return densityFunction;
        }));
        this.settings = supplier;
        int seaLevel = noiseGeneratorSettings.seaLevel();
        Aquifer.FluidStatus sea = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.defaultFluid());
        this.globalFluidPicker = (x, y, z) -> sea;
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    protected void doCreateBiomes(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseChunk noiseChunk = chunkAccess.getOrCreateNoiseChunk(chunkAccess1 -> this.createNoiseChunk((ChunkAccess)chunkAccess1, structureManager, blender, randomState));
        Climate.Sampler sampler = ((NoiseChunkExtension)noiseChunk).the_bumblezone$getCachedClimateSampler();
        BiomeResolver biomeresolver = this.getBiomeResolver((BiomeResolver)((NoiseChunkExtension)noiseChunk).the_bumblezone$getBiomeSource());
        chunkAccess.fillBiomesFromNoise(biomeresolver, sampler);
    }

    private BiomeResolver getBiomeResolver(BiomeResolver biomeResolver) {
        return (x, y, z, biomeHolder) -> biomeResolver.getNoiseBiome(x, 0, z, biomeHolder);
    }

    protected NoiseChunk createNoiseChunk(ChunkAccess chunkAccess, StructureManager structureManager, Blender blender, RandomState randomState) {
        NoiseChunk noiseChunk = super.createNoiseChunk(chunkAccess, structureManager, blender, randomState);
        this.postInitNoiseChunk(randomState, noiseChunk);
        return noiseChunk;
    }

    private void postInitNoiseChunk(RandomState randomState, NoiseChunk noiseChunk) {
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof BzBiomeSource) {
            BzBiomeSource bzBiomeSource = (BzBiomeSource)biomeSource;
            ((NoiseChunkExtension)noiseChunk).the_bumblezone$setBiomeSource(new BzBiomeSource(bzBiomeSource));
        } else {
            ((NoiseChunkExtension)noiseChunk).the_bumblezone$setBiomeSource(this.biomeSource);
        }
        ((NoiseChunkExtension)noiseChunk).the_bumblezone$setCachedClimateSampler(((NoiseChunkAccessor)noiseChunk).bumblezone$callCachedClimateSampler(randomState.router(), ((NoiseGeneratorSettings)this.settings.value()).spawnTarget()));
    }

    public int getBaseHeight(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.iterateNoiseColumn(levelHeightAccessor, randomState, x, z, null, types.isOpaque()).orElse(levelHeightAccessor.getMinBuildHeight());
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        MutableObject mutableobject = new MutableObject();
        this.iterateNoiseColumn(levelHeightAccessor, randomState, x, z, (MutableObject<NoiseColumn>)mutableobject, null);
        return (NoiseColumn)mutableobject.getValue();
    }

    public void addDebugScreenInfo(List<String> strings, RandomState randomState, BlockPos blockPos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = randomState.router();
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        double d0 = noiserouter.ridges().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        strings.add("NoiseRouter T: " + decimalformat.format(noiserouter.temperature().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.vegetation().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.continents().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.erosion().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.depth().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.peaksAndValleys((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.initialDensityWithoutJaggedness().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.finalDensity().compute((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    protected OptionalInt iterateNoiseColumn(LevelHeightAccessor levelHeightAccessor, RandomState randomState, int x, int z, MutableObject<NoiseColumn> mutableObject, Predicate<BlockState> blockStatePredicate) {
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().clampToHeightAccessor(levelHeightAccessor);
        int i = noisesettings.getCellHeight();
        int j = noisesettings.minY();
        int k = Mth.floorDiv((int)j, (int)i);
        int l = Mth.floorDiv((int)noisesettings.height(), (int)i);
        if (l > 0) {
            BlockState[] ablockstate;
            if (mutableObject == null) {
                ablockstate = null;
            } else {
                ablockstate = new BlockState[noisesettings.height()];
                mutableObject.setValue((Object)new NoiseColumn(j, ablockstate));
            }
            int i1 = noisesettings.getCellWidth();
            int j1 = Math.floorDiv(x, i1);
            int k1 = Math.floorDiv(z, i1);
            int l1 = Math.floorMod(x, i1);
            int i2 = Math.floorMod(z, i1);
            int j2 = j1 * i1;
            int k2 = k1 * i1;
            double d0 = (double)l1 / (double)i1;
            double d1 = (double)i2 / (double)i1;
            NoiseChunk noiseChunk = new NoiseChunk(1, randomState, j2, k2, noisesettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, (NoiseGeneratorSettings)this.settings.value(), this.globalFluidPicker, Blender.empty());
            this.postInitNoiseChunk(randomState, noiseChunk);
            noiseChunk.initializeForFirstCellX();
            noiseChunk.advanceCellX(0);
            for (int l2 = l - 1; l2 >= 0; --l2) {
                noiseChunk.selectCellYZ(l2, 0);
                for (int i3 = i - 1; i3 >= 0; --i3) {
                    BlockState blockstate1;
                    int j3 = (k + l2) * i + i3;
                    double d2 = (double)i3 / (double)i;
                    noiseChunk.updateForY(j3, d2);
                    noiseChunk.updateForX(x, d0);
                    noiseChunk.updateForZ(z, d1);
                    BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).bumblezone$callGetInterpolatedState();
                    BlockState blockState = blockstate1 = blockstate == null ? this.defaultBlock : blockstate;
                    if (ablockstate != null) {
                        int k3 = l2 * i + i3;
                        ablockstate[k3] = blockstate1;
                    }
                    if (blockStatePredicate == null || !blockStatePredicate.test(blockstate1)) continue;
                    noiseChunk.stopInterpolation();
                    return OptionalInt.of(j3 + 1);
                }
            }
            noiseChunk.stopInterpolation();
        }
        return OptionalInt.empty();
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BiomeManager.NoiseBiomeSource noiseBiomeSource;
        BiomeManager biomeManager;
        WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)worldGenRegion);
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof BiomeManager.NoiseBiomeSource) {
            BiomeManager.NoiseBiomeSource noiseBiomeSource2 = (BiomeManager.NoiseBiomeSource)biomeSource;
            biomeManager = new BiomeManager(noiseBiomeSource2, worldGenRegion.getSeed());
        } else {
            biomeManager = worldGenRegion.getBiomeManager();
        }
        Blender blender = Blender.of((WorldGenRegion)worldGenRegion);
        NoiseChunk noisechunk = chunkAccess.getOrCreateNoiseChunk(noiseChunk -> this.createNoiseChunk((ChunkAccess)noiseChunk, structureManager, blender, randomState));
        BiomeSource biomeSource2 = ((NoiseChunkExtension)noisechunk).the_bumblezone$getBiomeSource();
        biomeManager = new NoVerticalBlendBiomeManager(biomeManager, biomeSource2 instanceof BiomeManager.NoiseBiomeSource ? (noiseBiomeSource = (BiomeManager.NoiseBiomeSource)biomeSource2) : null);
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.value();
        randomState.surfaceSystem().buildSurface(randomState, biomeManager, (Registry)worldGenRegion.registryAccess().registry(Registries.BIOME).get(), noisegeneratorsettings.useLegacyRandomSource(), worldgenerationcontext, chunkAccess, noisechunk, noisegeneratorsettings.surfaceRule());
    }

    public void buildSurface(ChunkAccess chunkAccess, WorldGenerationContext worldGenerationContext, RandomState randomState, StructureManager structureManager, BiomeManager biomeManager, Registry<Biome> biomeRegistry, Blender blender) {
        NoiseChunk noisechunk = chunkAccess.getOrCreateNoiseChunk(noiseChunk -> this.createNoiseChunk((ChunkAccess)noiseChunk, structureManager, blender, randomState));
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.value();
        randomState.surfaceSystem().buildSurface(randomState, biomeManager, biomeRegistry, noisegeneratorsettings.useLegacyRandomSource(), worldGenerationContext, chunkAccess, noisechunk, noisegeneratorsettings.surfaceRule());
    }

    public void applyCarvers(WorldGenRegion worldGenRegion, long seed, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    protected ChunkAccess doFill(Blender blender, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, int x, int z) {
        NoiseChunk noiseChunk = chunkAccess.getOrCreateNoiseChunk(chunkAccess1 -> this.createNoiseChunk((ChunkAccess)chunkAccess1, structureManager, blender, randomState));
        Heightmap heightmap = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = chunkAccess.getPos();
        int i = chunkpos.getMinBlockX();
        int j = chunkpos.getMinBlockZ();
        Aquifer aquifer = noiseChunk.aquifer();
        noiseChunk.initializeForFirstCellX();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().getCellWidth();
        int l = ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().getCellHeight();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noiseChunk.advanceCellX(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                int bottomBlockY = chunkAccess.getSectionsCount() - 1;
                LevelChunkSection levelchunksection = chunkAccess.getSection(chunkAccess.getSectionsCount() - 1);
                for (int i2 = z - 1; i2 >= 0; --i2) {
                    noiseChunk.selectCellYZ(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (x + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = chunkAccess.getSectionIndex(k2);
                        if (bottomBlockY != i3) {
                            levelchunksection = chunkAccess.getSection(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noiseChunk.updateForY(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noiseChunk.updateForX(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noiseChunk.updateForZ(j4, d2);
                                BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).bumblezone$callGetInterpolatedState();
                                if (blockstate == null) {
                                    blockstate = this.defaultBlock;
                                }
                                if (blockstate == Blocks.AIR.defaultBlockState()) continue;
                                levelchunksection.setBlockState(l3, l2, k4, blockstate, false);
                                heightmap.update(l3, k2, k4, blockstate);
                                heightmap1.update(l3, k2, k4, blockstate);
                                if (!aquifer.shouldScheduleFluidUpdate() || blockstate.getFluidState().isEmpty()) continue;
                                blockpos$mutableblockpos.set(k3, k2, j4);
                                chunkAccess.markPosForPostprocessing((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noiseChunk.swapSlices();
        }
        noiseChunk.stopInterpolation();
        return chunkAccess;
    }

    public int getGenDepth() {
        return ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().height();
    }

    public int getSeaLevel() {
        return ((NoiseGeneratorSettings)this.settings.value()).seaLevel();
    }

    public int getMinY() {
        return ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().minY();
    }

    public Holder<NoiseGeneratorSettings> generatorSettings() {
        return this.settings;
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
        if (!((NoiseGeneratorSettings)this.settings.value()).disableMobGeneration()) {
            ChunkPos chunkpos = region.getCenter();
            Holder holder = region.getBiome(chunkpos.getWorldPosition().atY(region.getMaxBuildHeight() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
            worldgenrandom.setDecorationSeed(region.getSeed(), chunkpos.getMinBlockX(), chunkpos.getMinBlockZ());
            BzChunkGenerator.spawnNonBeeMobsForChunkGeneration((ServerLevelAccessor)region, (Holder<Biome>)holder, chunkpos, (RandomSource)worldgenrandom);
        }
    }

    public static void spawnNonBeeMobsForChunkGeneration(ServerLevelAccessor serverLevelAccessor, Holder<Biome> biomeHolder, ChunkPos chunkPos, RandomSource randomSource) {
        MobSpawnSettings mobspawnsettings = ((Biome)biomeHolder.value()).getMobSettings();
        WeightedRandomList weightedrandomlist = mobspawnsettings.getMobs(MobCategory.CREATURE);
        if (BzGeneralConfigs.specialBeeSpawning) {
            weightedrandomlist = WeightedRandomList.create(weightedrandomlist.unwrap().stream().filter(e -> e.type != EntityType.BEE).toList());
        }
        if (!weightedrandomlist.isEmpty()) {
            int minX = chunkPos.getMinBlockX();
            int minZ = chunkPos.getMinBlockZ();
            int seaLevel = ((ServerChunkCache)serverLevelAccessor.getChunkSource()).getGenerator().getSeaLevel();
            while ((double)randomSource.nextFloat() < (double)mobspawnsettings.getCreatureProbability() * 0.5) {
                Optional optional = weightedrandomlist.getRandom(randomSource);
                if (!optional.isPresent()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = (MobSpawnSettings.SpawnerData)optional.get();
                int groupCount = mobspawnsettings$spawnerdata.minCount + randomSource.nextInt(1 + mobspawnsettings$spawnerdata.maxCount - mobspawnsettings$spawnerdata.minCount);
                SpawnGroupData spawngroupdata = null;
                int x = minX + randomSource.nextInt(16);
                int z = minZ + randomSource.nextInt(16);
                int tempX = x;
                int tempZ = z;
                for (int l1 = 0; l1 < groupCount; ++l1) {
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, randomSource.nextInt(250 - seaLevel) + seaLevel, z);
                    if (serverLevelAccessor.dimensionType().hasCeiling()) {
                        do {
                            mutableBlockPos.move(Direction.DOWN);
                        } while (!serverLevelAccessor.getBlockState((BlockPos)mutableBlockPos).isAir());
                        do {
                            mutableBlockPos.move(Direction.DOWN);
                        } while (serverLevelAccessor.getBlockState((BlockPos)mutableBlockPos).isAir() && mutableBlockPos.getY() > serverLevelAccessor.getMinBuildHeight());
                    }
                    if (mobspawnsettings$spawnerdata.type.canSummon()) {
                        float mobWidth = mobspawnsettings$spawnerdata.type.getWidth();
                        double finalX = Mth.clamp((double)((double)x + 0.5), (double)((double)minX + (double)mobWidth + 0.5), (double)((double)minX + 15.5 - (double)mobWidth));
                        double finalZ = Mth.clamp((double)((double)z + 0.5), (double)((double)minZ + (double)mobWidth + 0.5), (double)((double)minZ + 15.5 - (double)mobWidth));
                        if (!serverLevelAccessor.getWorldBorder().isWithinBounds(finalX, finalZ) || mutableBlockPos.getY() < serverLevelAccessor.getMinBuildHeight() || mutableBlockPos.getY() >= serverLevelAccessor.getMaxBuildHeight()) continue;
                        Entity entity = null;
                        try {
                            entity = mobspawnsettings$spawnerdata.type.create((Level)serverLevelAccessor.getLevel());
                            entity.moveTo(finalX, (double)mutableBlockPos.getY(), finalZ, randomSource.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof Mob) {
                                Mob mob = (Mob)entity;
                                PlatformService.INSTANCE.finalizeSpawn(mob, serverLevelAccessor, null, MobSpawnType.CHUNK_GENERATION);
                                if (mob.checkSpawnObstruction((LevelReader)serverLevelAccessor)) {
                                    spawngroupdata = mob.finalizeSpawn(serverLevelAccessor, serverLevelAccessor.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.CHUNK_GENERATION, spawngroupdata);
                                    mob.moveTo(mob.getX(), mob.getY() + 1.0, mob.getZ());
                                    serverLevelAccessor.addFreshEntityWithPassengers((Entity)mob);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Bumblezone.LOGGER.error("Failed to create mob: {}", (Object)entity);
                            exception.addSuppressed(new RuntimeException("Failed to create mob: " + String.valueOf(entity)));
                            throw exception;
                        }
                    }
                    x += randomSource.nextInt(5) - randomSource.nextInt(5);
                    z += randomSource.nextInt(5) - randomSource.nextInt(5);
                    while (x < minX || x >= minX + 16 || z < minZ || z >= minZ + 16) {
                        x = tempX + randomSource.nextInt(5) - randomSource.nextInt(5);
                        z = tempZ + randomSource.nextInt(5) - randomSource.nextInt(5);
                    }
                }
            }
        }
    }

    public record BiomeNoise(Supplier<BiomeSource> biomeSource, Supplier<Climate.Sampler> sampler) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<BiomeNoise> CODEC = KeyDispatchDataCodec.of((MapCodec)MapCodec.unit((Object)new BiomeNoise(null, null)));

        public double compute(DensityFunction.FunctionContext functionContext) {
            if (this.biomeSource == null || this.biomeSource.get() == null || this.sampler == null) {
                throw new IllegalStateException("Attempting to sample uninitialized BzChunkGenerator$BiomeNoise");
            }
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.blockX(), functionContext.blockZ(), this.sampler.get(), this.biomeSource.get(), BiomeRegistryHolder.BIOME_REGISTRY);
        }

        public double minValue() {
            return -10.0;
        }

        public double maxValue() {
            return 10.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }
}

