/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.handlers.TradeHintParticleSpawnPacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record TradeHintParticleSpawnPacket(int queenId, Item wantItem, List<ItemStack> rewardItemStacks) implements Packet<TradeHintParticleSpawnPacket>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"trade_hint_particle_spawn");
    public static final ClientboundPacketType<TradeHintParticleSpawnPacket> TYPE = new Handler();

    public static void sendToClient(Entity queen, Item wantItem, List<ItemStack> rewardItems) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayersInLevel((Packet)new TradeHintParticleSpawnPacket(queen.getId(), wantItem, rewardItems), queen.level());
    }

    public PacketType<TradeHintParticleSpawnPacket> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<TradeHintParticleSpawnPacket> {
        private Handler() {
        }

        public void encode(TradeHintParticleSpawnPacket message, RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(message.queenId());
            buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)message.wantItem));
            buffer.writeInt(message.rewardItemStacks().size());
            for (ItemStack rewardItem : message.rewardItemStacks()) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)rewardItem);
            }
        }

        public TradeHintParticleSpawnPacket decode(RegistryFriendlyByteBuf buffer) {
            int queenId = buffer.readInt();
            Item wantItem = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
            int sizeOfRewards = buffer.readInt();
            ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>(sizeOfRewards);
            for (int i = 0; i < sizeOfRewards; ++i) {
                rewardItems.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            return new TradeHintParticleSpawnPacket(queenId, wantItem, rewardItems);
        }

        public Runnable handle(TradeHintParticleSpawnPacket message) {
            return () -> TradeHintParticleSpawnPacketHandler.handle(message);
        }

        public Class<TradeHintParticleSpawnPacket> type() {
            return TradeHintParticleSpawnPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

