/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules.neoforge;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.neoforge.BzAttachmentTypes;
import com.telepathicgrunt.the_bumblezone.modules.base.Module;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHolder;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistrar;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.attachment.AttachmentType;

public class NeoForgeModuleInitializer {
    private static final List<ModuleRegistryValue<?>> LIVING_ENTITY_MODULES = new ArrayList();
    private static final List<ModuleRegistryValue<?>> PLAYER_ENTITY_MODULES = new ArrayList();
    private static final List<ModuleRegistryValue<?>> PERSIST_PLAYER_DATA_SAVE_MODULES = new ArrayList();

    public static void init() {
        ModuleRegistry.register(new ModuleRegistrar(){

            @Override
            public <T extends Module<T>> void registerPlayerModule(ModuleHolder<T> moduleHolder, boolean runDataCloneForPlayer) {
                ModuleRegistryValue<T> moduleRegistryValue = new ModuleRegistryValue<T>(moduleHolder.id(), moduleHolder.codec(), moduleHolder.factory());
                PLAYER_ENTITY_MODULES.add(moduleRegistryValue);
                if (runDataCloneForPlayer) {
                    PERSIST_PLAYER_DATA_SAVE_MODULES.add(moduleRegistryValue);
                }
            }

            @Override
            public <T extends Module<T>> void registerLivingEntityModule(ModuleHolder<T> moduleHolder, boolean runDataCloneForPlayer) {
                ModuleRegistryValue<T> moduleRegistryValue = new ModuleRegistryValue<T>(moduleHolder.id(), moduleHolder.codec(), moduleHolder.factory());
                LIVING_ENTITY_MODULES.add(moduleRegistryValue);
                if (runDataCloneForPlayer) {
                    PERSIST_PLAYER_DATA_SAVE_MODULES.add(moduleRegistryValue);
                }
            }
        });
        for (ModuleRegistryValue<?> value : LIVING_ENTITY_MODULES) {
            AttachmentType.Builder<?> builder = NeoForgeModuleInitializer.getAttachmentTypeBuilder(value);
            BzAttachmentTypes.ATTACHMENT_TYPES.register(((Module)value.factory.get()).id().getPath(), () -> builder.build());
        }
        for (ModuleRegistryValue<?> value : PLAYER_ENTITY_MODULES) {
            BzAttachmentTypes.ATTACHMENT_TYPES.register(((Module)value.factory.get()).id().getPath(), () -> {
                AttachmentType.Builder builder = NeoForgeModuleInitializer.getAttachmentTypeBuilder(value);
                if (PERSIST_PLAYER_DATA_SAVE_MODULES.contains(value)) {
                    builder.copyOnDeath();
                }
                return builder.build();
            });
        }
    }

    private static <T extends Module<T>> AttachmentType.Builder<T> getAttachmentTypeBuilder(ModuleRegistryValue<T> value) {
        return AttachmentType.builder(value.factory()).serialize(value.codec());
    }

    private record ModuleRegistryValue<T extends Module<T>>(ResourceLocation id, Codec<T> codec, Supplier<T> factory) {
    }
}

