/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EssenceOfTheBees
extends Item {
    public EssenceOfTheBees(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (EssenceOfTheBees.hasEssence(serverPlayer)) {
                MutableComponent message = Component.translatable((String)"item.the_bumblezone.essence_of_the_bees.already_essenced").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD);
                serverPlayer.displayClientMessage((Component)message, true);
                return itemStack;
            }
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            EssenceOfTheBees.setEssence(serverPlayer, true);
            if (!serverPlayer.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            EssenceOfTheBees.spawnParticles((ServerLevel)level, serverPlayer.position(), serverPlayer.getRandom());
            level.playSound(null, serverPlayer.blockPosition(), (SoundEvent)BzSounds.BEE_ESSENCE_CONSUMED.get(), SoundSource.PLAYERS, 2.0f, serverPlayer.getRandom().nextFloat() * 0.2f + 0.6f);
            for (MobEffectInstance effectToRemove : new ArrayList(serverPlayer.getActiveEffects())) {
                if (((MobEffect)effectToRemove.getEffect().value()).isBeneficial()) continue;
                serverPlayer.removeEffect(effectToRemove.getEffect());
            }
        }
        return itemStack;
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, location.x(), location.y() + 1.0, location.z(), 100, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1 + 0.1, random.nextGaussian() * 0.1, (double)random.nextFloat() * 0.4 + (double)0.2f);
        world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, location.x(), location.y() + 1.0, location.z(), 400, 1.0, 1.0, 1.0, (double)random.nextFloat() * 0.5 + (double)1.2f);
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 75;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return (SoundEvent)BzSounds.BEE_ESSENCE_CONSUMING.get();
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)BzSounds.BEE_ESSENCE_CONSUMING.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public static void setEssence(ServerPlayer serverPlayer, boolean newValue) {
        PlatformService.INSTANCE.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
            capability.isBeeEssenced = newValue;
        });
    }

    public static boolean hasEssence(ServerPlayer serverPlayer) {
        return PlatformService.INSTANCE.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).map(c -> c.isBeeEssenced).orElse(false);
    }
}

