/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ServerPlayerAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class ContinuityEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.continuityEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> 1;
    private static final ConcurrentLinkedQueue<TickCapsule> NEXT_TICK_BEHAVIORS = new ConcurrentLinkedQueue();
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"MCPE-28723")));

    public ContinuityEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_continuity_description_1").withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_continuity_description_2").withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        TickCapsule tickCapsule = NEXT_TICK_BEHAVIORS.poll();
        if (tickCapsule != null) {
            if (level.getGameTime() > tickCapsule.tickTarget) {
                tickCapsule.runnable().run();
            } else {
                NEXT_TICK_BEHAVIORS.add(tickCapsule);
            }
        }
        super.inventoryTick(itemStack, level, entity, i, bl);
    }

    @Override
    void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
    }

    public static boolean CancelledDeath(BzEntityDeathEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof ServerPlayer) {
            Item item;
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource source = event.source();
            Registry damageTypeRegistry = player.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            if (damageTypeRegistry.get(DamageTypes.GENERIC_KILL) == event.source().type() && source.getEntity() == null && source.getDirectEntity() == null && source.getSourcePosition() == null) {
                return false;
            }
            ItemStack itemStack = player.getOffhandItem();
            if (player.isDeadOrDying() && (item = itemStack.getItem()) instanceof ContinuityEssence) {
                ContinuityEssence continuityEssence = (ContinuityEssence)item;
                if (((AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive() && !player.getCooldowns().isOnCooldown(itemStack.getItem())) {
                    ContinuityEssence.playerReset(player);
                    ArrayList mobEffectInstances = new ArrayList(player.getActiveEffects());
                    for (MobEffectInstance mobEffectInstance : mobEffectInstances) {
                        if (((MobEffect)mobEffectInstance.getEffect().value()).isBeneficial()) continue;
                        player.removeEffect(mobEffectInstance.getEffect());
                    }
                    MinecraftServer server = player.level().getServer();
                    if (server != null) {
                        ContinuityEssence.spawnParticles(player.serverLevel(), player.position(), player.getRandom());
                        ContinuityEssence.respawn(itemStack, continuityEssence, player, server, event.source());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void respawn(ItemStack stack, ContinuityEssence continuityEssence, ServerPlayer serverPlayer, MinecraftServer server, DamageSource damageSource) {
        boolean isRespawnAnchor;
        BlockPos playerRespawnBlockPos;
        Vec3 playerRespawnPosition;
        ServerLevel finalDestination;
        ResourceKey oldDimension = serverPlayer.level().dimension();
        BlockPos oldPosition = serverPlayer.blockPosition();
        ResourceKey respawnDimension = serverPlayer.getRespawnDimension();
        BlockPos respawningLinkedPosition = serverPlayer.getRespawnPosition();
        ServerLevel desiredDestination = server.getLevel(respawnDimension);
        Optional optionalRespawnPoint = desiredDestination != null && respawningLinkedPosition != null ? Optional.of(serverPlayer.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING).pos()) : Optional.empty();
        ServerLevel serverLevel = finalDestination = desiredDestination != null && optionalRespawnPoint.isPresent() ? desiredDestination : server.overworld();
        if (optionalRespawnPoint.isEmpty() && respawningLinkedPosition != null) {
            serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        if (optionalRespawnPoint.isPresent()) {
            playerRespawnPosition = (Vec3)optionalRespawnPoint.get();
            playerRespawnBlockPos = BlockPos.containing((Position)playerRespawnPosition);
            BlockState blockState = finalDestination.getBlockState(respawningLinkedPosition);
            isRespawnAnchor = blockState.is(Blocks.RESPAWN_ANCHOR);
        } else {
            playerRespawnPosition = finalDestination.getSharedSpawnPos().getCenter();
            playerRespawnBlockPos = finalDestination.getSharedSpawnPos();
            isRespawnAnchor = false;
        }
        BzWorldSavedData.queueEntityToGenericTeleport((Entity)serverPlayer, (ResourceKey<Level>)finalDestination.dimension(), playerRespawnBlockPos, () -> {
            if (isRespawnAnchor) {
                serverPlayer.connection.send((Packet)new ClientboundSoundPacket((Holder)SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, (double)respawningLinkedPosition.getX(), (double)respawningLinkedPosition.getY(), (double)respawningLinkedPosition.getZ(), 1.0f, 1.0f, finalDestination.getRandom().nextLong()));
            }
            ContinuityEssence.playerReset(serverPlayer);
            ItemStack respawnedPlayerStack = serverPlayer.getOffhandItem();
            Item patt0$temp = respawnedPlayerStack.getItem();
            if (patt0$temp instanceof ContinuityEssence) {
                ContinuityEssence continuityEssenceRespawnedPlayer = (ContinuityEssence)patt0$temp;
                continuityEssenceRespawnedPlayer.decrementAbilityUseRemaining(respawnedPlayerStack, serverPlayer, 1);
            }
            NEXT_TICK_BEHAVIORS.add(new TickCapsule(() -> {
                ContinuityEssence.spawnParticles(finalDestination, playerRespawnPosition, finalDestination.getRandom());
                serverPlayer.getCooldowns().addCooldown((Item)continuityEssence, continuityEssence.getCooldownTickLength());
            }, serverPlayer.serverLevel().getGameTime() + 5L));
        });
        ContinuityEssence.spawnBook(serverPlayer, damageSource, (ResourceKey<Level>)oldDimension, oldPosition, finalDestination, playerRespawnPosition);
    }

    private static void spawnBook(ServerPlayer serverPlayer, DamageSource damageSource, ResourceKey<Level> oldDimension, BlockPos oldPosition, ServerLevel finalDestination, Vec3 playerRespawnPosition) {
        ItemStack newBook = Items.WRITTEN_BOOK.getDefaultInstance();
        ArrayList<Filterable> componentList = new ArrayList<Filterable>();
        Entity causer = damageSource.getEntity();
        if (causer == null) {
            componentList.add(Filterable.passThrough((Object)Component.translatable((String)"item.the_bumblezone.essence_continuity_written_book_body_no_causer", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.getX(), oldPosition.getY(), oldPosition.getZ(), oldDimension.location().toString(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)})));
        } else {
            componentList.add(Filterable.passThrough((Object)Component.translatable((String)"item.the_bumblezone.essence_continuity_written_book_body", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.getX(), oldPosition.getY(), oldPosition.getZ(), oldDimension.location().toString(), causer.getName(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)})));
        }
        newBook.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(Filterable.from((FilteredText)FilteredText.fullyFiltered((String)"Essence of Continuity Record")), serverPlayer.getName().getString(), 0, componentList, true));
        ItemEntity itementity = new ItemEntity((Level)finalDestination, playerRespawnPosition.x(), playerRespawnPosition.y(), playerRespawnPosition.z(), newBook);
        itementity.setDefaultPickUpDelay();
        finalDestination.addFreshEntity((Entity)itementity);
    }

    public static Component getDeathMessage(ServerLevel serverLevel, DamageSource damageSource, ServerPlayer serverPlayer) {
        if (damageSource.type() == serverLevel.damageSources().generic().type()) {
            return Component.translatable((String)"death.attack.generic", (Object[])new Object[]{serverPlayer.getDisplayName()});
        }
        DeathMessageType deathMessageType = damageSource.type().deathMessageType();
        if (deathMessageType == DeathMessageType.FALL_VARIANTS && damageSource.getEntity() != null) {
            return ContinuityEssence.getFallMessage(damageSource.getEntity(), serverPlayer);
        }
        if (deathMessageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String string = "death.attack." + damageSource.getMsgId();
            MutableComponent component = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)(string + ".link"))).withStyle(INTENTIONAL_GAME_DESIGN_STYLE);
            return Component.translatable((String)(string + ".message"), (Object[])new Object[]{serverPlayer.getDisplayName(), component});
        }
        return damageSource.getLocalizedDeathMessage((LivingEntity)serverPlayer);
    }

    private static Component getFallMessage(Entity entity, ServerPlayer serverPlayer) {
        Component component = entity.getDisplayName();
        if (component != null) {
            return ContinuityEssence.getMessageForAssistedFall(serverPlayer, entity, component, "death.fell.finish.item", "death.fell.finish");
        }
        return Component.translatable((String)"death.fell.killer", (Object[])new Object[]{entity.getDisplayName()});
    }

    private static Component getMessageForAssistedFall(ServerPlayer serverPlayer, Entity entity, Component component, String string, String string2) {
        ItemStack itemStack;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            itemStack = livingEntity.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (!itemStack.isEmpty() && itemStack.has(DataComponents.CUSTOM_NAME)) {
            return Component.translatable((String)string, (Object[])new Object[]{serverPlayer.getDisplayName(), component, itemStack.getDisplayName()});
        }
        return Component.translatable((String)string2, (Object[])new Object[]{serverPlayer.getDisplayName(), component});
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, location.x(), location.y() + 1.0, location.z(), 100, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1 + 0.1, random.nextGaussian() * 0.1, (double)random.nextFloat() * 0.4 + (double)0.2f);
        world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, location.x(), location.y() + 1.0, location.z(), 400, 1.0, 1.0, 1.0, (double)random.nextFloat() * 0.5 + (double)1.2f);
    }

    private static void playerReset(ServerPlayer player) {
        player.setHealth(player.getMaxHealth());
        player.getFoodData().setExhaustion(0.0f);
        player.getFoodData().eat(20, 20.0f);
        player.clearFire();
        player.setAirSupply(player.getMaxAirSupply());
        ((ServerPlayerAccessor)player).bumblezone$setStartingToFallPosition(null);
        player.invulnerableTime = 40;
        player.deathTime = 0;
        player.fallDistance = 0.0f;
        player.stopSleeping();
        player.removeVehicle();
        player.ejectPassengers();
        player.setPortalCooldown();
        player.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        player.setOldPosAndRot();
        for (MobEffectInstance effect : new ArrayList(player.getActiveEffects())) {
            if (((MobEffect)effect.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
            player.removeEffect(effect.getEffect());
        }
    }

    private record TickCapsule(Runnable runnable, long tickTarget) {
    }
}

