/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.dispenserbehavior;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HoneyFluidBucketDispenseBehavior
extends DefaultDispenseItemBehavior {
    private static final DefaultDispenseItemBehavior DROP_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();

    public ItemStack execute(BlockSource source, ItemStack stack) {
        BucketItem bucketitem = (BucketItem)stack.getItem();
        ServerLevel world = source.level();
        Position dispensePosition = DispenserBlock.getDispensePosition((BlockSource)source);
        BlockPos dispenseBlockPos = BlockPos.containing((Position)dispensePosition);
        BlockState blockstate = world.getBlockState(dispenseBlockPos);
        if (bucketitem.emptyContents(null, (Level)world, dispenseBlockPos, null)) {
            bucketitem.checkExtraContent(null, (Level)world, stack, dispenseBlockPos);
            return new ItemStack((ItemLike)Items.BUCKET);
        }
        if (blockstate.is((Block)BzBlocks.HONEYCOMB_BROOD.get()) && stack.is(BzTags.BEE_FEEDING_ITEMS)) {
            boolean deniedBeeSpawn = false;
            int stage = (Integer)blockstate.getValue((Property)HoneycombBrood.STAGE);
            if (stage == 3) {
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().set((Vec3i)dispenseBlockPos);
                blockpos.move(((Direction)blockstate.getValue((Property)HoneycombBrood.FACING)).getOpposite());
                if (!world.getBlockState((BlockPos)blockpos).isSolid()) {
                    Mob beeEntity = (Mob)EntityType.BEE.create((Level)world);
                    beeEntity.moveTo((double)((float)blockpos.getX() + 0.5f), (double)blockpos.getY(), (double)((float)blockpos.getZ() + 0.5f), beeEntity.getRandom().nextFloat() * 360.0f, 0.0f);
                    beeEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)beeEntity.position())), MobSpawnType.TRIGGERED, null);
                    beeEntity.setBaby(true);
                    PlatformService.INSTANCE.finalizeSpawn(beeEntity, (ServerLevelAccessor)world, null, MobSpawnType.DISPENSER);
                    deniedBeeSpawn = !world.addFreshEntity((Entity)beeEntity);
                    world.setBlockAndUpdate(dispenseBlockPos, (BlockState)blockstate.setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(0)));
                }
            } else {
                for (double xOffset = 0.0; xOffset <= 1.0; xOffset += 1.0) {
                    for (double yOffset = 0.0; yOffset <= 1.0; yOffset += 1.0) {
                        for (double zOffset = 0.0; zOffset <= 1.0; zOffset += 1.0) {
                            world.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)dispenseBlockPos.getX() + xOffset, (double)dispenseBlockPos.getY() + yOffset - (double)0.4f, (double)dispenseBlockPos.getZ() + zOffset, 1, (double)(world.getRandom().nextFloat() * 0.3f - 0.15f), (double)(world.getRandom().nextFloat() * 0.2f - 0.1f), (double)(world.getRandom().nextFloat() * 0.3f - 0.15f), (double)(world.getRandom().nextFloat() * 0.2f + 0.2f));
                        }
                    }
                }
                world.setBlockAndUpdate(dispenseBlockPos, (BlockState)blockstate.setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(3)));
            }
            if (!deniedBeeSpawn) {
                stack.shrink(1);
                if (!stack.isEmpty()) {
                    HoneyFluidBucketDispenseBehavior.addBucketToDispenser(source);
                } else {
                    stack = new ItemStack((ItemLike)Items.BUCKET);
                }
            }
            return stack;
        }
        return DROP_ITEM_BEHAVIOR.dispense(source, stack);
    }

    private static void addBucketToDispenser(BlockSource source) {
        ItemStack honeyBottle;
        DispenserBlockEntity dispenser;
        if (source.blockEntity() instanceof DispenserBlockEntity && !HopperBlockEntity.addItem(null, (Container)(dispenser = source.blockEntity()), (ItemStack)(honeyBottle = new ItemStack((ItemLike)Items.BUCKET)), null).isEmpty()) {
            DROP_ITEM_BEHAVIOR.dispense(source, honeyBottle);
        }
    }
}

