/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class SugarWaterBubbleColumnBlock
extends BubbleColumnBlock {
    public SugarWaterBubbleColumnBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WATER).liquid().noCollission().strength(100.0f, 100.0f).noLootTable().replaceable().sound(SoundType.EMPTY).pushReaction(PushReaction.DESTROY));
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        levelAccessor.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)BzItems.SUGAR_WATER_BUCKET.get());
    }

    public FluidState getFluidState(BlockState blockState) {
        return ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getSource(false);
    }

    public Optional<SoundEvent> getPickupSound() {
        return ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getPickupSound();
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowState = levelReader.getBlockState(blockPos.below());
        return belowState.is((Block)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get()) || belowState.is(Blocks.BUBBLE_COLUMN) || belowState.is(BzTags.DOWNWARD_BUBBLE_COLUMN_CAUSING) || belowState.is(BzTags.UPWARD_BUBBLE_COLUMN_CAUSING);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        levelAccessor.scheduleTick(blockPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)levelAccessor));
        if (!blockState.canSurvive((LevelReader)levelAccessor, blockPos) || direction == Direction.DOWN || direction == Direction.UP && !blockState2.is(Blocks.BUBBLE_COLUMN) && SugarWaterBubbleColumnBlock.canExistIn(blockState2)) {
            levelAccessor.scheduleTick(blockPos, (Block)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get(), 5);
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        SugarWaterBubbleColumnBlock.updateColumn((LevelAccessor)serverLevel, blockPos, blockState, serverLevel.getBlockState(blockPos.below()));
    }

    public static void updateColumn(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        SugarWaterBubbleColumnBlock.updateColumn(levelAccessor, blockPos, levelAccessor.getBlockState(blockPos), blockState);
    }

    public static void updateColumn(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        if (SugarWaterBubbleColumnBlock.canExistIn(blockState)) {
            boolean isVanilla;
            BlockState sugarWaterColumnState = SugarWaterBubbleColumnBlock.getColumnState(blockState2);
            levelAccessor.setBlock(blockPos, sugarWaterColumnState, 2);
            BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable().move(Direction.UP);
            boolean isBubblePlacing = sugarWaterColumnState.is((Block)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get());
            BlockState currentState = levelAccessor.getBlockState((BlockPos)mutableBlockPos);
            boolean bl = isVanilla = currentState.is(Blocks.WATER) && currentState.getFluidState().isSource() || currentState.is(Blocks.BUBBLE_COLUMN);
            while (SugarWaterBubbleColumnBlock.canExistIn(currentState) || isVanilla) {
                if (isVanilla ? !levelAccessor.setBlock((BlockPos)mutableBlockPos, !isBubblePlacing ? Blocks.WATER.defaultBlockState() : (BlockState)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue((Property)DRAG_DOWN, (Comparable)((Boolean)sugarWaterColumnState.getValue((Property)DRAG_DOWN))), 2) : !levelAccessor.setBlock((BlockPos)mutableBlockPos, sugarWaterColumnState, 2)) {
                    return;
                }
                mutableBlockPos.move(Direction.UP);
                currentState = levelAccessor.getBlockState((BlockPos)mutableBlockPos);
                isVanilla = currentState.is(Blocks.WATER) || currentState.is(Blocks.BUBBLE_COLUMN);
            }
        }
    }

    private static BlockState getColumnState(BlockState blockState) {
        if (blockState.is((Block)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get())) {
            return blockState;
        }
        if (blockState.is(BzTags.UPWARD_BUBBLE_COLUMN_CAUSING) || blockState.is(Blocks.BUBBLE_COLUMN) && !((Boolean)blockState.getValue((Property)BubbleColumnBlock.DRAG_DOWN)).booleanValue()) {
            return (BlockState)((SugarWaterBubbleColumnBlock)((Object)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get())).defaultBlockState().setValue((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(false));
        }
        if (blockState.is(BzTags.DOWNWARD_BUBBLE_COLUMN_CAUSING) || blockState.is(Blocks.BUBBLE_COLUMN) && ((Boolean)blockState.getValue((Property)BubbleColumnBlock.DRAG_DOWN)).booleanValue()) {
            return (BlockState)((SugarWaterBubbleColumnBlock)((Object)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get())).defaultBlockState().setValue((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(true));
        }
        return ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState();
    }

    private static boolean canExistIn(BlockState blockState) {
        return blockState.is((Block)BzFluids.SUGAR_WATER_BUBBLE_COLUMN_BLOCK.get()) || blockState.is((Block)BzFluids.SUGAR_WATER_BLOCK.get()) && blockState.getFluidState().getAmount() >= 8 && blockState.getFluidState().isSource();
    }

    @Deprecated
    public void entityInside(BlockState state, Level world, BlockPos position, Entity entity) {
        Bee beeEntity;
        if (entity instanceof Bee && !(beeEntity = (Bee)entity).isDeadOrDying() && beeEntity.hurtMarked) {
            beeEntity.heal(1.0f);
        }
        super.entityInside(state, world, position, entity);
    }
}

