/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.enchantments.NeurotoxinsEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.enchantments.PotentPoisonEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.ParalyzeMarker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownStingerSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(ThrownStingerSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownStingerSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ItemStack DEFAULT_SPEAR_STACK = new ItemStack((ItemLike)BzItems.STINGER_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownStingerSpearEntity(EntityType<? extends ThrownStingerSpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownStingerSpearEntity(Level level, LivingEntity livingEntity, ItemStack ammo, ItemStack weaponItem) {
        super((EntityType)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get(), livingEntity, level, ammo, weaponItem);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(weaponItem));
        this.entityData.set(ID_FOIL, (Object)weaponItem.hasFoil());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
    }

    private byte getLoyaltyFromItem(ItemStack itemStack) {
        byte by;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var3;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte loyalty = (Byte)this.entityData.get(ID_LOYALTY);
        if (loyalty > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)loyalty, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double returnSpeed = 0.05 * (double)loyalty;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(returnSpeed)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.playSound((SoundEvent)BzSounds.STINGER_SPEAR_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity;
        LivingEntity livingEntity;
        Entity entity2 = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        Level level = this.level();
        float damageAmount = 1.5f;
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damageAmount += EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity2, (DamageSource)damageSource, (float)damageAmount);
        }
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        if (entity2.hurt(damagesource, damageAmount)) {
            if (entity2.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity hitEntity = (LivingEntity)entity2;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity2, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity2 = hitEntity;
                    this.doKnockback(livingEntity2, damageSource);
                    this.doPostHurtEffects(livingEntity2);
                }
                this.doPostHurtEffects(hitEntity);
            }
        }
        if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).isDeadOrDying() && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!serverPlayer.blockPosition().closerThan((Vec3i)this.blockPosition(), 50.0)) {
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_LONG_RANGE_KILL_TRIGGER.get())).trigger(serverPlayer);
            }
            if (entity2.getType() == EntityType.WITHER && PlayerDataHandler.rootAdvancementDone(serverPlayer)) {
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_KILLED_WITH_WITHER_TRIGGER.get())).trigger(serverPlayer);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound((SoundEvent)BzSounds.STINGER_SPEAR_HIT.get(), 1.0f, 1.0f);
    }

    protected void doPostHurtEffects(LivingEntity victim) {
        if (!victim.getType().is(EntityTypeTags.UNDEAD)) {
            PotentPoisonEnchantmentApplication.doPostAttackBoostedPoison(this.getPickupItemStackOrigin(), victim);
            Entity entity = this.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_POISONING_TRIGGER.get())).trigger(serverPlayer);
            }
            if ((entity = this.getOwner()) instanceof LivingEntity) {
                Pair<ParalyzeMarker, Integer> neurotoxin;
                LivingEntity ownerEntity = (LivingEntity)entity;
                if (!victim.getType().is(BzTags.PARALYZED_IMMUNE) && (neurotoxin = NeurotoxinsEnchantmentApplication.getNeurotoxinEnchantLevel(this.getPickupItemStackOrigin())) != null && (Integer)neurotoxin.getSecond() > 0) {
                    this.getPickupItemStackOrigin().hurtAndBreak(((ParalyzeMarker)neurotoxin.getFirst()).durabilityDrainOnValidTargetHit(), ownerEntity, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    protected float getWaterInertia() {
        return 0.75f;
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    protected EntityHitResult findHitEntity(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.findHitEntity(vec3, vec31);
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected ItemStack getDefaultPickupItem() {
        return ((Item)BzItems.STINGER_SPEAR.get()).getDefaultInstance();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)BzSounds.STINGER_SPEAR_HIT_GROUND.get();
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void tickDespawn() {
        byte loyalty = (Byte)this.entityData.get(ID_LOYALTY);
        if (!(this.isInvulnerable() || this.pickup == AbstractArrow.Pickup.ALLOWED && loyalty > 0)) {
            super.tickDespawn();
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.dealtDamage = compoundTag.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.getWeaponItem()));
        this.entityData.set(ID_FOIL, (Object)compoundTag.getBoolean("IsFoil"));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean("DealtDamage", this.dealtDamage);
        compoundTag.putBoolean("IsFoil", this.isFoil());
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

