/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeAngerAttackingGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeBreedGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFaceRandomGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFloatGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeHopGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeRevengeGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeTemptGoal;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.AgeableMobAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class HoneySlimeEntity
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> IN_HONEY = SynchedEntityData.defineId(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> IN_HONEY_GROWTH_TIME = SynchedEntityData.defineId(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANGRY_TIMER = SynchedEntityData.defineId(HoneySlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt MAX_ANGER_DURATION = TimeUtil.rangeOfSeconds((int)22, (int)36);
    private UUID target_UUID;
    private static final HashSet<Block> HONEY_BASED_BLOCKS = new HashSet();
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public HoneySlimeEntity(Level worldIn) {
        this((EntityType<? extends HoneySlimeEntity>)((EntityType)BzEntities.HONEY_SLIME.get()), worldIn);
    }

    public HoneySlimeEntity(EntityType<? extends HoneySlimeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new HoneySlimeMoveController(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new HoneySlimeFloatGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HoneySlimeRevengeGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HoneySlimeAngerAttackingGoal(this));
        this.goalSelector.addGoal(2, (Goal)new HoneySlimeBreedGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new HoneySlimeTemptGoal(this));
        this.goalSelector.addGoal(4, (Goal)new HoneySlimeHopGoal(this));
        this.goalSelector.addGoal(4, (Goal)new HoneySlimeFaceRandomGoal(this));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        this.setupHoneySlime(this.isBaby(), true);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IN_HONEY, (Object)true);
        builder.define(IN_HONEY_GROWTH_TIME, (Object)0);
        builder.define(ANGRY_TIMER, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (AgeableMobAccessor.bumblezone$getDATA_BABY_ID().equals(key)) {
            this.refreshDimensions();
            if (!this.isPassenger()) {
                this.setYRot(this.yHeadRot);
                this.setYBodyRot(this.yHeadRot);
            }
            if (this.isInWater() && this.random.nextInt(20) == 0) {
                this.doWaterSplashEffect();
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("inHoney", this.isInHoney());
        compound.putInt("inHoneyGrowthTimer", this.getInHoneyGrowthTime());
        compound.putBoolean("wasOnGround", this.wasOnGround);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setInHoney(compound.getBoolean("inHoney"));
        this.setInHoneyGrowthTime(compound.getInt("inHoneyGrowthTimer"));
        this.wasOnGround = compound.getBoolean("wasOnGround");
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 2.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    protected void setupHoneySlime(boolean isBaby, boolean resetHealth) {
        this.reapplyPosition();
        this.refreshDimensions();
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(isBaby ? 2.0 : 8.0);
        Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue((double)((0.2f + 0.1f * (float)(isBaby ? 1 : 2)) * 2.0f));
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(isBaby ? 1.0 : 3.0);
        if (resetHealth) {
            this.setHealth(this.getMaxHealth());
        }
        this.xpReward = isBaby ? 1 : 2;
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide() && this.isDeadOrDying()) {
            Player player;
            LivingEntity flag2;
            if (!this.isBaby()) {
                Component component = this.getCustomName();
                boolean flag2 = this.isNoAi();
                int splitAmount = 2 + this.random.nextInt(3);
                ArrayList<Mob> children = new ArrayList<Mob>();
                for (int currentNewSlime = 0; currentNewSlime < splitAmount; ++currentNewSlime) {
                    float xOffset = ((float)(currentNewSlime % 2) - 0.5f) * 0.5f;
                    float zOffset = ((float)(currentNewSlime / 2) - 0.5f) * 0.5f;
                    if (this.isInHoney()) {
                        HoneySlimeEntity honeySlime = (HoneySlimeEntity)((EntityType)BzEntities.HONEY_SLIME.get()).create(this.level());
                        if (honeySlime == null) continue;
                        if (this.isPersistenceRequired()) {
                            honeySlime.setPersistenceRequired();
                        }
                        honeySlime.setBaby(true);
                        honeySlime.setCustomName(component);
                        honeySlime.setNoAi(flag2);
                        honeySlime.setInvulnerable(this.isInvulnerable());
                        honeySlime.setupHoneySlime(honeySlime.isBaby(), true);
                        honeySlime.moveTo(this.getX() + (double)xOffset, this.getY() + 0.5, this.getZ() + (double)zOffset, this.random.nextFloat() * 360.0f, 0.0f);
                        children.add((Mob)honeySlime);
                        continue;
                    }
                    Slime slime = (Slime)EntityType.SLIME.create(this.level());
                    if (slime == null) continue;
                    if (this.isPersistenceRequired()) {
                        slime.setPersistenceRequired();
                    }
                    slime.setCustomName(component);
                    slime.setNoAi(flag2);
                    slime.setInvulnerable(this.isInvulnerable());
                    slime.setSize(1, true);
                    slime.moveTo(this.getX() + (double)xOffset, this.getY() + 0.5, this.getZ() + (double)zOffset, this.random.nextFloat() * 360.0f, 0.0f);
                    children.add((Mob)slime);
                }
                if (PlatformService.INSTANCE.shouldMobSplit((Mob)this, children)) {
                    children.forEach(arg_0 -> ((Level)this.level()).addFreshEntity(arg_0));
                }
            }
            if (!(this.getLastAttacker() == null || (flag2 = this.getLastAttacker()) instanceof Player && (player = (Player)flag2).isCreative())) {
                List honeySlimes = this.level().getEntitiesOfClass(HoneySlimeEntity.class, this.getBoundingBox().inflate(24.0));
                for (HoneySlimeEntity honeySlime : honeySlimes) {
                    honeySlime.startPersistentAngerTimer();
                    honeySlime.setPersistentAngerTarget(this.getLastAttacker().getUUID());
                    honeySlime.setTarget(this.getLastAttacker());
                }
            }
        }
        super.remove(removalReason);
    }

    public boolean isInHoney() {
        return (Boolean)this.entityData.get(IN_HONEY);
    }

    public void setInHoney(boolean value) {
        this.entityData.set(IN_HONEY, (Object)value);
    }

    public int getInHoneyGrowthTime() {
        return (Integer)this.entityData.get(IN_HONEY_GROWTH_TIME);
    }

    public void setInHoneyGrowthTime(int value) {
        this.entityData.set(IN_HONEY_GROWTH_TIME, (Object)value);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        if (distance > 1.0f) {
            this.playSound(this.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_SQUISH.get(), 0.4f, 1.0f);
        }
        int fallDamage = this.calculateFallDamage(distance, damageMultiplier);
        if (this.isInHoney()) {
            fallDamage = (int)((float)fallDamage * 0.35f - 3.0f);
        }
        if (fallDamage <= 0) {
            return false;
        }
        this.hurt(damageSource, fallDamage);
        this.playBlockFallSound();
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isBaby() && this.isInHoney() && itemstack.getItem() == Items.GLASS_BOTTLE) {
            this.level().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(player, hand, new ItemStack((ItemLike)Items.HONEY_BOTTLE), false, true);
            this.getHoneyFromSlime((LivingEntity)this);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                    this.setLastHurtByMob((LivingEntity)player);
                }
                ((GenericTrigger)((Object)BzCriterias.HONEY_SLIME_HARVEST_TRIGGER.get())).trigger(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private void getHoneyFromSlime(LivingEntity entity) {
        if (entity instanceof HoneySlimeEntity) {
            this.setInHoney(false);
            this.setInHoneyGrowthTime(-14400);
        }
    }

    public void tick() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.tick();
        if (this.onGround() && !this.wasOnGround) {
            int i = 2;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.random.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.random.nextFloat() * 0.5f + 0.5f;
                float f2 = Mth.sin((float)f) * (float)i * 0.5f * f1;
                float f3 = Mth.cos((float)f) * (float)i * 0.5f * f1;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Blocks.HONEY_BLOCK)), this.getX() + (double)f2, this.getY(), this.getZ() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.playSound(this.getSquishSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.onGround() && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.onGround();
        this.alterSquishAmount();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            if (!this.isInHoney()) {
                this.setInHoneyGrowthTime(this.getInHoneyGrowthTime() + 1);
                if (HONEY_BASED_BLOCKS.isEmpty()) {
                    HONEY_BASED_BLOCKS.addAll(Stream.of(Blocks.HONEY_BLOCK, (Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get(), (Block)BzBlocks.HONEYCOMB_BROOD.get(), (Block)BzBlocks.STICKY_HONEY_REDSTONE.get(), (Block)BzBlocks.STICKY_HONEY_RESIDUE.get()).collect(Collectors.toCollection(HashSet::new)));
                }
                if (!this.level().isClientSide() && HONEY_BASED_BLOCKS.contains(this.level().getBlockState(this.blockPosition().below()).getBlock()) && (double)this.random.nextFloat() < 0.001) {
                    this.setInHoneyGrowthTime(0);
                }
            }
            this.setInHoney(this.getInHoneyGrowthTime() >= 0);
        }
    }

    protected void customServerAiStep() {
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(BzTags.HONEY_SLIME_DESIRED_ITEMS);
    }

    public AgeableMob getBreedOffspring(ServerLevel worldIn, AgeableMob ageable) {
        HoneySlimeEntity childHoneySlimeEntity = (HoneySlimeEntity)((EntityType)BzEntities.HONEY_SLIME.get()).create((Level)worldIn);
        if (childHoneySlimeEntity != null) {
            childHoneySlimeEntity.setupHoneySlime(true, true);
        }
        return childHoneySlimeEntity;
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby()) {
            this.setupHoneySlime(false, true);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.isAlive()) {
            int i = 2;
            if (this.distanceToSqr((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.hasLineOfSight((Entity)entityIn) && entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), this.getAttackStrength())) {
                this.playSound((SoundEvent)BzSounds.HONEY_SLIME_ATTACK.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.dealDamage(entityIn);
            }
        }
    }

    public boolean canDamagePlayer() {
        return !this.isBaby() && this.isEffectiveAi();
    }

    public void playerTouch(Player entityIn) {
        if (this.canDamagePlayer() && this.getTarget() == entityIn) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    public EntityType<? extends HoneySlimeEntity> getType() {
        return super.getType();
    }

    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.absMoveTo(x, y, z);
    }

    public boolean canBeLeashed() {
        return !this.isLeashed();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public int getJumpDelay() {
        return this.random.nextInt(20) + 10;
    }

    protected float getAttackStrength() {
        return (float)Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).getValue();
    }

    protected boolean shouldDropLoot() {
        return true;
    }

    public float getSoundVolume() {
        return 0.4f * (float)(this.isBaby() ? 1 : 2);
    }

    public int getMaxHeadXRot() {
        return 0;
    }

    public boolean makesSoundOnJump() {
        return !this.isBaby();
    }

    public void jumpFromGround() {
        Vec3 vec3d = this.getDeltaMovement();
        if (this.isAngry()) {
            this.setDeltaMovement(vec3d.x * 5.0, this.getJumpPower() * 1.3f, vec3d.z * 5.0);
        } else {
            this.setDeltaMovement(vec3d.x, this.getJumpPower(), vec3d.z);
        }
        this.hasImpulse = true;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGRY_TIMER);
    }

    public void setRemainingPersistentAngerTime(int ticks) {
        this.entityData.set(ANGRY_TIMER, (Object)ticks);
    }

    public UUID getPersistentAngerTarget() {
        return this.target_UUID;
    }

    public void setPersistentAngerTarget(UUID uuid) {
        this.target_UUID = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(MAX_ANGER_DURATION.sample(this.random));
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_HURT_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_DEATH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_DEATH.get();
    }

    protected SoundEvent getSquishSound() {
        return this.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_SQUISH.get();
    }

    public SoundEvent getJumpSound() {
        return this.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_JUMP_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_JUMP.get();
    }
}

