/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.advancements.EntitySpecificTrigger;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.events.block.BzBlockBreakEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerPickupItemEvent;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<EntityType<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<EntityType<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupBeeHatingList() {
        for (ResourceLocation id : BuiltInRegistries.ENTITY_TYPE.keySet()) {
            String mobName = id.getPath();
            if (mobName.contains("bee") || mobName.contains("bumble_beast")) {
                SET_OF_BEE_NAMED_ENTITIES.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(id));
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(id));
        }
    }

    public static void minedBlockAnger(boolean cancelled, BzBlockBreakEvent event) {
        if (cancelled) {
            return;
        }
        Player player = event.player();
        BlockState blockState = event.state();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (blockState.is(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
                if (blockState.is((Block)BzBlocks.HONEYCOMB_BROOD.get()) && EnchantmentHelper.hasTag((ItemStack)serverPlayer.getMainHandItem(), (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                    return;
                }
                BeeAggression.angerBees(serverPlayer, blockState.is((Block)BzBlocks.HONEYCOMB_BROOD.get()));
            }
        }
    }

    public static void pickupItemAnger(BzPlayerPickupItemEvent event) {
        Player player = event.player();
        ItemStack itemStack = event.item();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (itemStack.is(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
                BeeAggression.angerBees(serverPlayer, false);
            }
        }
    }

    private static void angerBees(ServerPlayer player, boolean removesProt) {
        if ((player.level().dimension().equals(BzDimension.BZ_WORLD_KEY) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees && !player.isCreative() && !player.isSpectator()) {
            if (!player.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                if (!EssenceOfTheBees.hasEssence(player) && player.level().getDifficulty() != Difficulty.PEACEFUL) {
                    MutableComponent message = Component.translatable((String)"system.the_bumblezone.no_protection").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                    player.displayClientMessage((Component)message, true);
                    player.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            } else {
                ((GenericTrigger)((Object)BzCriterias.HONEY_PERMISSION_TRIGGER.get())).trigger(player);
                if (removesProt) {
                    player.removeEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                }
            }
        }
    }

    public static void onLivingEntityHurt(BzEntityHurtEvent event) {
        LivingEntity livingEntity = event.entity();
        if (event.amount() > 0.0f && livingEntity != null && !livingEntity.level().isClientSide() && livingEntity instanceof Bee && event.source() != null && event.source().getEntity() != null && livingEntity.level().getDifficulty() != Difficulty.PEACEFUL) {
            BeeAggression.beeHitAndAngered((Entity)livingEntity, event.source().getEntity());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(Entity entity, Entity attackerEntity) {
        if (attackerEntity instanceof Player) {
            Player player = (Player)attackerEntity;
            if (!((Player)attackerEntity).isCreative() && !attackerEntity.isSpectator()) {
                if (player.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                    player.removeEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                    WrathOfTheHiveEffect.calmTheBees(player.level(), (LivingEntity)player);
                    return;
                }
                if (!entity.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
                    if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
                }
                if (!BzBeeAggressionConfigs.aggressiveBees) return;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((EntitySpecificTrigger)((Object)BzCriterias.BEE_HIT_WRATH_OF_THE_HIVE_TRIGGER.get())).trigger(serverPlayer, attackerEntity);
                }
                player.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                return;
            }
        }
        if (!(attackerEntity instanceof Mob)) return;
        Mob mob = (Mob)attackerEntity;
        if (mob.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
            mob.removeEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder());
            WrathOfTheHiveEffect.calmTheBees(mob.level(), (LivingEntity)mob);
            return;
        }
        if (!entity.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
            if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
        }
        if (!BzBeeAggressionConfigs.aggressiveBees) return;
        mob.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, true));
    }

    public static void entityTypeBeeAnger(Entity entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((Mob)entity).addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        }
        if (entity != null && entity.level() != null && !entity.level().isClientSide() && entity.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
            for (ModCompat compat : ModChecker.DIM_SPAWN_COMPATS) {
                compat.onEntitySpawnInDimension(entity);
            }
        }
    }

    public static boolean doesBeesHateEntity(Entity entity) {
        OwnableEntity ownableEntity;
        Mob mobEntity;
        if (entity != null && entity.level() != null && !entity.level().isClientSide() && entity.level().dimension().equals(BzDimension.BZ_WORLD_KEY) && BzBeeAggressionConfigs.aggressiveBees && entity instanceof Mob && !(mobEntity = (Mob)entity).isNoAi() && (!(entity instanceof OwnableEntity) || (ownableEntity = (OwnableEntity)entity).getOwnerUUID() == null)) {
            if (mobEntity.getType().is(BzTags.FORCED_BEE_CALM_AT)) {
                return false;
            }
            if (mobEntity.getType().is(BzTags.FORCED_BEE_ANGRY_AT)) {
                return true;
            }
            return SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.getType()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.getType()) && mobEntity.getType().is(EntityTypeTags.ARTHROPOD);
        }
        return false;
    }

    public static boolean isBeelikeEntity(Entity entity) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(entity.getType());
    }

    public static boolean isBeelikeEntityType(EntityType<?> type) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(type);
    }

    public static void playerTick(Player playerEntity) {
        if (!playerEntity.level().isClientSide() && playerEntity.hasEffect(BzEffects.WRATH_OF_THE_HIVE.holder())) {
            if (playerEntity.level().getDifficulty() == Difficulty.PEACEFUL) {
                playerEntity.removeEffect(BzEffects.WRATH_OF_THE_HIVE.holder());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.level(), (LivingEntity)playerEntity);
            } else if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
                playerEntity.removeEffect(BzEffects.WRATH_OF_THE_HIVE.holder());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.level(), (LivingEntity)playerEntity);
            }
        }
        if (playerEntity.level().isClientSide()) {
            boolean wrathEffect = playerEntity.hasEffect(BzEffects.WRATH_OF_THE_HIVE.holder());
            if (wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, BzClientConfigs.playWrathOfHiveEffectMusic);
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, false);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.level(), (LivingEntity)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }

    public static void applyAngerIfInTaggedStructures(ServerPlayer serverPlayer) {
        StructureManager structureManager = ((ServerLevel)serverPlayer.level()).structureManager();
        if (structureManager.getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.WRATH_CAUSING).isValid()) {
            if (!FlowerHeadwearHelmet.getFlowerHeadwear((LivingEntity)serverPlayer).isEmpty()) {
                ((GenericTrigger)((Object)BzCriterias.FLOWER_HEADWEAR_WRATH_STRUCTURE_TRIGGER.get())).trigger(serverPlayer);
                return;
            }
            if (serverPlayer.isCreative() || serverPlayer.isSpectator() || EssenceOfTheBees.hasEssence(serverPlayer)) {
                return;
            }
            if (!BzBeeAggressionConfigs.aggressiveBees || serverPlayer.level().getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
            if (!serverPlayer.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                if (!serverPlayer.hasEffect(BzEffects.WRATH_OF_THE_HIVE.holder())) {
                    MutableComponent message = Component.translatable((String)"system.the_bumblezone.no_protection").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                    serverPlayer.displayClientMessage((Component)message, true);
                }
                serverPlayer.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
            }
        }
    }

    public static void preventAngerOnEssencedPlayers(List<Bee> beeList, List<Player> playerList) {
        for (int i = playerList.size() - 1; i >= 0; --i) {
            ServerPlayer serverPlayer;
            Player player = playerList.get(i);
            if (!(player instanceof ServerPlayer) || !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player)) continue;
            for (Bee bee : beeList) {
                if (bee.getTarget() != player) continue;
                bee.setTarget(null);
            }
            playerList.remove(i);
        }
    }

    public static void preventAngerOnEssencedPlayers(Player player, List<Entity> entityList) {
        ServerPlayer serverPlayer;
        if (player != null && player.level().isClientSide() || player instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player)) {
            entityList.clear();
        }
    }
}

