/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterCommandsEvent;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DebugDevOpCommands {
    public static void createCommand(BzRegisterCommandsEvent commandEvent) {
        if (!PlatformService.INSTANCE.isDevEnvironment()) {
            return;
        }
        CommandDispatcher<CommandSourceStack> commandDispatcher = commandEvent.dispatcher();
        String commandCooldownString = "bumblezone_cooldown";
        String cooldownTimeArg = "cooldown_time";
        String entityArg = "entity_to_check";
        LiteralCommandNode source = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandCooldownString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)entityArg, (ArgumentType)EntityArgument.players()).then(Commands.argument((String)cooldownTimeArg, (ArgumentType)IntegerArgumentType.integer()).executes(cs -> {
            DebugDevOpCommands.setCooldown((CommandSourceStack)cs.getSource(), EntityArgument.getPlayers((CommandContext)cs, (String)entityArg), (Integer)cs.getArgument(cooldownTimeArg, Integer.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandCooldownString).redirect((CommandNode)source));
    }

    private static void setCooldown(CommandSourceStack commandSourceStack, Collection<ServerPlayer> targets, int cooldownTime, CommandContext<CommandSourceStack> cs) {
        for (ServerPlayer targetPlayer : targets) {
            for (ItemStack itemStack : targetPlayer.getHandSlots()) {
                if (itemStack.isEmpty()) continue;
                targetPlayer.getCooldowns().addCooldown(itemStack.getItem(), cooldownTime);
            }
            for (ItemStack itemStack : targetPlayer.getArmorSlots()) {
                if (itemStack.isEmpty()) continue;
                targetPlayer.getCooldowns().addCooldown(itemStack.getItem(), cooldownTime);
            }
            for (ItemStack itemStack : targetPlayer.getInventory().items) {
                if (itemStack.isEmpty()) continue;
                targetPlayer.getCooldowns().addCooldown(itemStack.getItem(), cooldownTime);
            }
        }
        MutableComponent mutableComponent = Component.literal((String)"Cooldown Applied");
        commandSourceStack.sendSuccess(() -> mutableComponent, true);
    }
}

