/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class StingerSpearRenderer
extends EntityRenderer<ThrownStingerSpearEntity> {
    public static final ResourceLocation STINGER_SPEAR_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/stinger_spear.png");
    private final StingerSpearModel model;

    public StingerSpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new StingerSpearModel(context.bakeLayer(StingerSpearModel.LAYER_LOCATION));
    }

    public void render(ThrownStingerSpearEntity thrownStingerSpearEntity, float float1, float float2, PoseStack poseStack, MultiBufferSource multiBufferSource, int int1) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)float2, (float)thrownStingerSpearEntity.yRotO, (float)thrownStingerSpearEntity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)float2, (float)thrownStingerSpearEntity.xRotO, (float)thrownStingerSpearEntity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)this.model.renderType(this.getTextureLocation(thrownStingerSpearEntity)), (boolean)false, (boolean)thrownStingerSpearEntity.isFoil());
        this.model.renderToBuffer(poseStack, vertexconsumer, int1, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)thrownStingerSpearEntity, float1, float2, poseStack, multiBufferSource, int1);
    }

    public ResourceLocation getTextureLocation(ThrownStingerSpearEntity thrownStingerSpearEntity) {
        return STINGER_SPEAR_LOCATION;
    }
}

