/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.sentrywatcher.SentryWatcherModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.SentryWatcherEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class SentryWatcherRenderer<M extends EntityModel<SentryWatcherEntity>>
extends EntityRenderer<SentryWatcherEntity>
implements RenderLayerParent<SentryWatcherEntity, M> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/sentry_watcher.png");
    protected final SentryWatcherModel model;
    protected final List<RenderLayer<SentryWatcherEntity, M>> layers = Lists.newArrayList();

    public SentryWatcherRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SentryWatcherModel(context.bakeLayer(SentryWatcherModel.LAYER_LOCATION));
        this.addLayer(new EyeLayerRenderer(this));
    }

    protected final boolean addLayer(RenderLayer<SentryWatcherEntity, M> renderLayer) {
        return this.layers.add(renderLayer);
    }

    public M getModel() {
        return (M)((Object)this.model);
    }

    public void render(SentryWatcherEntity sentryWatcherEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        float rotationLerp = Mth.lerp((float)g, (float)sentryWatcherEntity.xRotO, (float)sentryWatcherEntity.getXRot());
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.0, sentryWatcherEntity.getBoundingBox().getYsize() + (double)0.05f, 0.0);
        float shakeEffect = 0.0f;
        if (sentryWatcherEntity.hasShaking()) {
            shakeEffect += (float)(Math.cos((double)sentryWatcherEntity.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        poseStack.mulPose(Axis.YN.rotationDegrees(sentryWatcherEntity.getYRot() + shakeEffect));
        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f - sentryWatcherEntity.getXRot()));
        this.model.prepareMobModel(sentryWatcherEntity, 0.0f, 0.0f, g);
        this.model.setupAnim(sentryWatcherEntity, 0.0f, 0.0f, 0.0f, 0.0f, rotationLerp);
        Minecraft minecraft = Minecraft.getInstance();
        boolean glowing = minecraft.shouldEntityAppearGlowing((Entity)sentryWatcherEntity);
        RenderType renderType = this.getRenderType(sentryWatcherEntity, true, false, glowing);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(renderType);
            this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, -1);
        }
        if (!sentryWatcherEntity.isSpectator()) {
            for (RenderLayer<SentryWatcherEntity, M> renderLayer : this.layers) {
                renderLayer.render(poseStack, multiBufferSource, i, (Entity)sentryWatcherEntity, 0.0f, 0.0f, g, 0.0f, 0.0f, rotationLerp);
            }
        }
        poseStack.popPose();
        super.render((Entity)sentryWatcherEntity, f, g, poseStack, multiBufferSource, i);
    }

    @Nullable
    protected RenderType getRenderType(SentryWatcherEntity sentryWatcherEntity, boolean bodyVisible, boolean hidden, boolean glowing) {
        ResourceLocation resourceLocation = this.getTextureLocation(sentryWatcherEntity);
        if (bodyVisible) {
            return this.model.renderType(resourceLocation);
        }
        if (glowing) {
            return RenderType.outline((ResourceLocation)resourceLocation);
        }
        return null;
    }

    public ResourceLocation getTextureLocation(SentryWatcherEntity sentryWatcherEntity) {
        return SKIN;
    }

    static class EyeLayerRenderer<T extends Entity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation EYES = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/sentry_watcher_eyes.png");
        private static final RenderType RENDER_TYPE_EYES = RenderType.eyes((ResourceLocation)EYES);
        protected SentryWatcherModel model;

        public EyeLayerRenderer(RenderLayerParent<T, M> renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T entity, float f, float g, float h, float j, float k, float l) {
            SentryWatcherEntity sentryWatcherEntity;
            if (entity instanceof SentryWatcherEntity && (sentryWatcherEntity = (SentryWatcherEntity)((Object)entity)).hasActivated()) {
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.renderType());
                this.getParentModel().renderToBuffer(poseStack, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
            }
        }

        public RenderType renderType() {
            return RENDER_TYPE_EYES;
        }
    }
}

