/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminGrassRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminShieldRenderer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import com.telepathicgrunt.the_bumblezone.mixin.client.BlockRenderDispatcherAccessor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RootminRenderer
extends MobRenderer<RootminEntity, RootminModel> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/rootmin.png");

    public RootminRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new RootminModel(context.bakeLayer(RootminModel.LAYER_LOCATION)), 0.7f);
        this.addLayer(new FlowerBlockLayer((RenderLayerParent<RootminEntity, RootminModel>)this, context.getBlockRenderDispatcher()));
        this.addLayer(new RootminGrassRenderer(this, context.getModelSet()));
        this.addLayer(new RootminShieldRenderer((RenderLayerParent<RootminEntity, RootminModel>)this, context.getModelSet()));
    }

    public void render(RootminEntity rootminEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        super.render((LivingEntity)rootminEntity, entityYaw, partialTicks, stack, buffer, packedLight);
        this.adjustShadow(rootminEntity, partialTicks);
        stack.popPose();
    }

    private void adjustShadow(RootminEntity rootminEntity, float partialTicks) {
        RootminState pose = rootminEntity.getRootminPose();
        float percentage = (20.0f - Math.max((float)rootminEntity.animationTimeBetweenHiding - partialTicks, 0.0f)) / 20.0f;
        float target = pose == RootminState.ENTITY_TO_BLOCK ? 0.0f : 0.7f;
        float from = pose != RootminState.ENTITY_TO_BLOCK ? 0.0f : 0.7f;
        this.shadowRadius = Mth.lerp((float)percentage, (float)from, (float)target);
        target = pose == RootminState.ENTITY_TO_BLOCK ? 0.0f : 1.0f;
        from = pose != RootminState.ENTITY_TO_BLOCK ? 0.0f : 1.0f;
        this.shadowStrength = Mth.lerp((float)percentage, (float)from, (float)target);
    }

    public ResourceLocation getTextureLocation(RootminEntity rootminEntity) {
        return SKIN;
    }

    protected float getBob(RootminEntity livingEntity, float f) {
        return super.getBob((LivingEntity)livingEntity, f);
    }

    protected float getAttackAnim(RootminEntity livingEntity, float f) {
        return super.getAttackAnim((LivingEntity)livingEntity, f);
    }

    protected boolean isBodyVisible(RootminEntity livingEntity) {
        return super.isBodyVisible((LivingEntity)livingEntity);
    }

    protected float getWhiteOverlayProgress(RootminEntity livingEntity, float f) {
        return super.getWhiteOverlayProgress((LivingEntity)livingEntity, f);
    }

    public static class FlowerBlockLayer
    extends RenderLayer<RootminEntity, RootminModel> {
        private final BlockRenderDispatcher blockRenderer;

        public FlowerBlockLayer(RenderLayerParent<RootminEntity, RootminModel> renderLayerParent, BlockRenderDispatcher blockRenderDispatcher) {
            super(renderLayerParent);
            this.blockRenderer = blockRenderDispatcher;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, RootminEntity rootminEntity, float f, float g, float h, float j, float k, float l) {
            BlockState blockState = rootminEntity.getFlowerBlock();
            if (blockState == null) {
                return;
            }
            ModelPart rootModel = ((RootminModel)this.getParentModel()).root();
            ModelPart bodyModel = rootModel.getChild("body");
            poseStack.pushPose();
            rootModel.translateAndRotate(poseStack);
            bodyModel.translateAndRotate(poseStack);
            poseStack.translate(-0.5f, -0.9375f, 0.5f);
            poseStack.scale(1.0f, -1.0f, -1.0f);
            this.renderSingleBlock(blockState, poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY, (BlockAndTintGetter)rootminEntity.level(), rootminEntity.blockPosition());
            if (blockState.getBlock() instanceof DoublePlantBlock) {
                blockState = (BlockState)blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                poseStack.translate(0.0f, 1.0f, 0.0f);
                this.renderSingleBlock(blockState, poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY, (BlockAndTintGetter)rootminEntity.level(), rootminEntity.blockPosition());
            }
            poseStack.popPose();
        }

        public void renderSingleBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, BlockAndTintGetter level, BlockPos blockPos) {
            RenderShape renderShape = blockState.getRenderShape();
            if (renderShape == RenderShape.INVISIBLE) {
                return;
            }
            switch (renderShape) {
                case MODEL: {
                    BakedModel bakedModel = this.blockRenderer.getBlockModel(blockState);
                    int k = ((BlockRenderDispatcherAccessor)this.blockRenderer).bumblezone$getBlockColors().getColor(blockState, level, blockPos, 1);
                    float f = (float)(k >> 16 & 0xFF) / 255.0f;
                    float g = (float)(k >> 8 & 0xFF) / 255.0f;
                    float h = (float)(k & 0xFF) / 255.0f;
                    this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)blockState, (boolean)false)), blockState, bakedModel, f, g, h, i, j);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ((BlockRenderDispatcherAccessor)this.blockRenderer).bumblezone$getBlockEntityRenderer().renderByItem(new ItemStack((ItemLike)blockState.getBlock()), ItemDisplayContext.NONE, poseStack, multiBufferSource, i, j);
                }
            }
        }
    }
}

