/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.HoneyCocoonBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.items.recipes.ContainerCraftingRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.LootrCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HoneyCocoon
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<HoneyCocoon> CODEC = Block.simpleCodec(HoneyCocoon::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty IS_LOOT_CONTAINER = BooleanProperty.create((String)"is_loot");
    protected final VoxelShape shape;
    public static final int waterDropDelay = 150;

    public HoneyCocoon() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(0.3f, 0.3f).randomTicks().noOcclusion().sound(SoundType.HONEY_BLOCK));
    }

    public HoneyCocoon(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)IS_LOOT_CONTAINER, (Comparable)Boolean.FALSE));
        VoxelShape voxelshape = Block.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
        voxelshape = Shapes.joinUnoptimized((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), (BooleanOp)BooleanOp.OR);
        voxelshape = Shapes.joinUnoptimized((VoxelShape)voxelshape, (VoxelShape)Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.OR);
        this.shape = voxelshape.optimize();
    }

    public MapCodec<? extends HoneyCocoon> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BzBlockEntities.HONEY_COCOON.get()).create(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, IS_LOOT_CONTAINER});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState blockstate, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)world));
            world.scheduleTick(currentPos, blockstate.getBlock(), 150);
        }
        return super.updateShape(blockstate, facing, facingState, world, currentPos, facingPos);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)world));
            world.scheduleTick(pos, blockstate.getBlock(), 150);
        }
        super.neighborChanged(blockstate, world, pos, block, fromPos, notify);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType().is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidstate.isSource()));
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity;
        if (!((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && (blockEntity = serverLevel.getBlockEntity(blockPos)) instanceof HoneyCocoonBlockEntity) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)blockEntity;
            if (!honeyCocoonBlockEntity.isUnpackedLoottable() || ((Boolean)blockState.getValue((Property)IS_LOOT_CONTAINER)).booleanValue()) {
                return;
            }
            BlockState aboveState = serverLevel.getBlockState(blockPos.above());
            if (!aboveState.getCollisionShape((BlockGetter)serverLevel, blockPos).isEmpty()) {
                return;
            }
            ArrayList<Pair> emptyBroods = new ArrayList<Pair>();
            ArrayList<Pair> beeFeeding = new ArrayList<Pair>();
            for (int i = 0; i < honeyCocoonBlockEntity.getContainerSize(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.getItem(i);
                if (itemStack.isEmpty()) continue;
                if (itemStack.getItem() == BzItems.EMPTY_HONEYCOMB_BROOD.get()) {
                    emptyBroods.add(new Pair((Object)itemStack, (Object)i));
                }
                if (!itemStack.is(BzTags.BEE_FEEDING_ITEMS)) continue;
                beeFeeding.add(new Pair((Object)itemStack, (Object)i));
            }
            if (emptyBroods.isEmpty() || beeFeeding.isEmpty()) {
                return;
            }
            honeyCocoonBlockEntity.removeItem((Integer)((Pair)emptyBroods.get(random.nextInt(emptyBroods.size()))).getSecond(), 1);
            ItemStack consumedItem = honeyCocoonBlockEntity.removeItem((Integer)((Pair)beeFeeding.get(random.nextInt(beeFeeding.size()))).getSecond(), 1);
            if (PlatformService.INSTANCE.hasCraftingRemainder(consumedItem)) {
                ItemStack ejectedItem = PlatformService.INSTANCE.getCraftingRemainder(consumedItem);
                if (ejectedItem.isEmpty()) {
                    ejectedItem = ContainerCraftingRecipe.HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(consumedItem.getItem()).getDefaultInstance();
                }
                if (!ejectedItem.isEmpty()) {
                    GeneralUtils.spawnItemEntity(serverLevel, blockPos, ejectedItem, 0.0, 0.2);
                }
            }
            boolean addedToInv = false;
            for (int i = 0; i < honeyCocoonBlockEntity.getContainerSize(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.getItem(i);
                if (!itemStack.isEmpty() && (itemStack.getItem() != BzItems.HONEYCOMB_BROOD.get() || itemStack.getCount() >= 64)) continue;
                if (itemStack.isEmpty()) {
                    honeyCocoonBlockEntity.setItem(i, ((Item)BzItems.HONEYCOMB_BROOD.get()).getDefaultInstance());
                } else {
                    itemStack.grow(1);
                }
                addedToInv = true;
                break;
            }
            if (!addedToInv) {
                GeneralUtils.spawnItemEntity(serverLevel, blockPos, ((Item)BzItems.HONEYCOMB_BROOD.get()).getDefaultInstance(), 0.0, 0.2);
            }
        }
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = serverLevel.getBlockEntity(blockPos)) instanceof HoneyCocoonBlockEntity) {
            HoneyCocoonBlockEntity honeyCocoonBlockEntity = (HoneyCocoonBlockEntity)blockEntity;
            if (!honeyCocoonBlockEntity.isUnpackedLoottable() || ((Boolean)blockState.getValue((Property)IS_LOOT_CONTAINER)).booleanValue()) {
                return;
            }
            BlockState aboveState = serverLevel.getBlockState(blockPos.above());
            if (!aboveState.getFluidState().is(FluidTags.WATER) || !aboveState.getCollisionShape((BlockGetter)serverLevel, blockPos).isEmpty()) {
                return;
            }
            serverLevel.scheduleTick(blockPos, blockState.getBlock(), 150);
            ArrayList<Pair> itemStacks = new ArrayList<Pair>();
            for (int i = 0; i < honeyCocoonBlockEntity.getContainerSize(); ++i) {
                ItemStack itemStack = honeyCocoonBlockEntity.getItem(i);
                if (itemStack.isEmpty()) continue;
                itemStacks.add(new Pair((Object)itemStack, (Object)i));
            }
            if (itemStacks.isEmpty()) {
                return;
            }
            ItemStack takenItem = honeyCocoonBlockEntity.removeItem((Integer)((Pair)itemStacks.get(random.nextInt(itemStacks.size()))).getSecond(), 1);
            GeneralUtils.spawnItemEntity(serverLevel, blockPos, takenItem, 0.0, -0.2);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        HoneyCocoonBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (itemStack.getItem() == Items.GLASS_BOTTLE && ((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)BzItems.SUGAR_WATER_BOTTLE.get()), false, true);
            return ItemInteractionResult.SUCCESS;
        }
        if (world.isClientSide) {
            world.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), (SoundEvent)BzSounds.HONEY_COCOON_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = null;
        if (ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat && ((Boolean)blockstate.getValue((Property)IS_LOOT_CONTAINER)).booleanValue() && (blockEntity2 = world.getBlockEntity(position)) instanceof HoneyCocoonBlockEntity && (blockEntity = (HoneyCocoonBlockEntity)blockEntity2).getLootTable() != null) {
            menuprovider = LootrCompat.getCocoonMenu((ServerPlayer)playerEntity, blockEntity);
        }
        if (menuprovider == null) {
            menuprovider = this.getMenuProvider(blockstate, world, position);
        }
        if (menuprovider != null) {
            playerEntity.openMenu(menuprovider);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockstate, LivingEntity livingEntity, ItemStack itemStack) {
        if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)level));
            level.scheduleTick(pos, blockstate.getBlock(), 150);
        }
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false && fluid.is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluid.defaultFluidState().isSource();
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.getType().is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidState.isSource()) {
            if (!world.isClientSide()) {
                world.setBlock(blockPos, (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.scheduleTick(blockPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)BzItems.SUGAR_WATER_BUCKET.get());
        }
        return ItemStack.EMPTY;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack itemStack) {
        if (EnchantmentHelper.getItemEnchantmentLevel(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, level), (ItemStack)itemStack) > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((GenericTrigger)((Object)BzCriterias.HONEY_COCOON_SILK_TOUCH_TRIGGER.get())).trigger(serverPlayer);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        if (itemStack.has(DataComponents.CONTAINER_LOOT)) {
            return;
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemStack2 : ((ItemContainerContents)itemStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            ++j;
            if (i > 4) continue;
            ++i;
            list.add((Component)Component.translatable((String)"container.the_bumblezone.honey_cocoon.item_count", (Object[])new Object[]{itemStack2.getHoverName(), itemStack2.getCount()}));
        }
        if (j - i > 0) {
            list.add((Component)Component.translatable((String)"container.the_bumblezone.honey_cocoon.more", (Object[])new Object[]{j - i}).withStyle(ChatFormatting.ITALIC));
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        if (!((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && random.nextFloat() < 0.05f) {
            this.spawnHoneyParticles(world, position, random);
        }
    }

    private void spawnHoneyParticles(Level world, BlockPos position, RandomSource random) {
        double x = random.nextDouble() * 14.0 + 1.0;
        double y = random.nextDouble() * 6.0 + 5.0;
        double z = random.nextDouble() * 14.0 + 1.0;
        if (random.nextBoolean()) {
            x = random.nextBoolean() ? 0.8 : 15.2;
        } else {
            z = random.nextBoolean() ? 0.8 : 15.2;
        }
        world.addParticle((ParticleOptions)ParticleTypes.FALLING_HONEY, x / 16.0 + (double)position.getX(), y / 16.0 + (double)position.getY(), z / 16.0 + (double)position.getZ(), 0.0, 0.0, 0.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return HoneyCocoon.createCocoonTicker(level, blockEntityType, (BlockEntityType<? extends HoneyCocoonBlockEntity>)((BlockEntityType)BzBlockEntities.HONEY_COCOON.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCocoonTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends HoneyCocoonBlockEntity> blockEntityType2) {
        return level.isClientSide ? null : HoneyCocoon.createTickerHelper(blockEntityType, blockEntityType2, HoneyCocoonBlockEntity::serverTick);
    }
}

