/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class EssenceBlockBlue
extends EssenceBlock {
    public static final MapCodec<EssenceBlockBlue> CODEC = Block.simpleCodec(EssenceBlockBlue::new);
    private static final int ENTITIES_TO_KILL = 50;

    public EssenceBlockBlue() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockBlue(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockBlue> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/blue_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.blueArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.blue_essence_event", BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_20).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/blue_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.CALMING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (entitiesKilled != 50 && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(50 - entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockBlue.SpawnNewEnemy(serverLevel, blockPos, blockState, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Mob mob;
                ServerPlayer player;
                UUID playerUUID;
                NeutralMob neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Entity entity = serverLevel.getEntity(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof NeutralMob && !((neutralMob = (NeutralMob)entity).getTarget() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
                    neutralMob.setRemainingPersistentAngerTime(Integer.MAX_VALUE);
                    neutralMob.setPersistentAngerTarget(playerUUID);
                    neutralMob.setTarget((LivingEntity)player);
                    continue;
                }
                if (!(entity instanceof Mob) || (mob = (Mob)entity).getTarget() instanceof Player) continue;
                playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
                player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
                mob.setTarget((LivingEntity)player);
            }
        }
        this.handleGiantBubbles(serverLevel, blockPos);
        float newProgress = (float)entitiesKilled / 50.0f;
        essenceBlockEntity.getEventBar().setProgress(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if (entitiesKilled == 50) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        EntityType entityTypeToSpawn;
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_NORMAL_ENEMY;
        boolean isStrong = false;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex == 28 || entityToSpawnIndex == 35 || entityToSpawnIndex == 48 || entityToSpawnIndex == 49 || entityToSpawnIndex == 50) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_STRONG_ENEMY;
            isStrong = true;
        } else if (entityToSpawnIndex >= 25) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_LATE_NORMAL_ENEMY;
        }
        List entityTypeList = BuiltInRegistries.ENTITY_TYPE.getTag(enemyTagToUse).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
        Direction direction = Direction.getRandom((RandomSource)serverLevel.getRandom());
        EntityType entityType = entityTypeToSpawn = entityTypeList.isEmpty() ? null : (EntityType)entityTypeList.get(serverLevel.getRandom().nextInt(entityTypeList.size()));
        if (entityTypeToSpawn == null) {
            return;
        }
        Entity entity = entityTypeToSpawn.spawn(serverLevel, blockPos.offset(direction.getStepX() * 3, direction.getStepY() * 3, direction.getStepZ() * 3), MobSpawnType.TRIGGERED);
        if (entity == null) {
            return;
        }
        entity.addTag("the_bumblezone.blue_essence_arena");
        eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.getUUID()));
        UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
        ServerPlayer player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            float maxHeart = Math.max(serverPlayer.getHealth(), serverPlayer.getMaxHealth());
            float maxArmor = serverPlayer.getArmorValue();
            float mobHealthBoost = maxHeart / 15.0f + maxArmor / 20.0f;
            float mobAttackBoost = maxHeart / 25.0f + maxArmor / 10.0f;
            boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
            if (!isEssenced) {
                mobHealthBoost *= 1.5f;
                mobAttackBoost *= 1.5f;
            }
            float timeProgress = 1.0f - (float)essenceBlockEntity.getEventTimer() / (float)((EssenceBlock)blockState.getBlock()).getEventTimeFrame();
            float enemyProgress = (float)essenceBlockEntity.getExtraEventTrackingProgress() / 50.0f;
            float progressDiff = (float)(Math.pow(enemyProgress - timeProgress + 1.0f, 2.0) - 1.0);
            if ((double)progressDiff > 0.1) {
                progressDiff = (float)(Math.pow((double)(enemyProgress - timeProgress) + 0.95, 5.0) - 0.95);
                mobHealthBoost += (float)((int)(progressDiff / 0.025f));
                mobAttackBoost += (float)((int)(progressDiff / 0.1f));
            }
            if (entity instanceof LivingEntity) {
                AttributeInstance livingEntityAttributeFollowRange;
                AttributeInstance livingEntityAttributeFlyingSpeed;
                AttributeInstance livingEntityAttributeSpeed;
                AttributeInstance livingEntityAttributeAttack;
                LivingEntity livingEntity = (LivingEntity)entity;
                AttributeInstance livingEntityAttributeHealth = livingEntity.getAttribute(Attributes.MAX_HEALTH);
                if (livingEntityAttributeHealth != null) {
                    livingEntityAttributeHealth.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_health_boost"), (double)mobHealthBoost, AttributeModifier.Operation.ADD_VALUE));
                    livingEntity.heal(mobHealthBoost);
                }
                if ((livingEntityAttributeAttack = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                    livingEntityAttributeAttack.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_damage_boost"), (double)mobAttackBoost, AttributeModifier.Operation.ADD_VALUE));
                }
                if ((livingEntityAttributeSpeed = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
                    livingEntityAttributeSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_speed_boost"), isEssenced ? 0.04 : 0.08, AttributeModifier.Operation.ADD_VALUE));
                }
                if ((livingEntityAttributeFlyingSpeed = livingEntity.getAttribute(Attributes.FLYING_SPEED)) != null) {
                    livingEntityAttributeFlyingSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_flying_speed_boost"), 0.02, AttributeModifier.Operation.ADD_VALUE));
                }
                if ((livingEntityAttributeFollowRange = livingEntity.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
                    livingEntityAttributeFollowRange.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_sight_boost"), 32.0, AttributeModifier.Operation.ADD_VALUE));
                }
            }
            if (entity instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)entity;
                neutralMob.setRemainingPersistentAngerTime(Integer.MAX_VALUE);
                neutralMob.setPersistentAngerTarget(playerUUID);
                neutralMob.setTarget((LivingEntity)serverPlayer);
            } else if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                List itemList = BuiltInRegistries.ITEM.getTag(BzTags.CALMING_ARENA_DROWNED_BONUS_HELD_ITEM).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
                ItemStack bonusItem = itemList.isEmpty() ? ItemStack.EMPTY : ((Item)itemList.get(serverLevel.getRandom().nextInt(itemList.size()))).getDefaultInstance();
                mob.setTarget((LivingEntity)serverPlayer);
                if (mob instanceof Drowned) {
                    ItemStack helmet;
                    Drowned drowned = (Drowned)mob;
                    ItemStack swimBoots = Items.LEATHER_BOOTS.getDefaultInstance();
                    swimBoots.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, (Level)serverLevel), 3);
                    drowned.equipItemIfPossible(swimBoots);
                    drowned.setDropChance(EquipmentSlot.FEET, 0.2f);
                    ItemStack leggings = Items.LEATHER_LEGGINGS.getDefaultInstance();
                    leggings.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.THORNS, (Level)serverLevel), 1);
                    drowned.equipItemIfPossible(leggings);
                    drowned.setDropChance(EquipmentSlot.LEGS, 0.2f);
                    ItemStack chestplate = Items.LEATHER_CHESTPLATE.getDefaultInstance();
                    chestplate.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, (Level)serverLevel), 1);
                    drowned.equipItemIfPossible(chestplate);
                    drowned.setDropChance(EquipmentSlot.CHEST, 0.2f);
                    ItemStack itemStack = helmet = serverLevel.getRandom().nextFloat() < 0.1f ? Items.TURTLE_HELMET.getDefaultInstance() : Items.LEATHER_HELMET.getDefaultInstance();
                    if (serverLevel.getRandom().nextFloat() < 0.75f) {
                        helmet.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY, (Level)serverLevel), 1);
                    } else {
                        helmet.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.RESPIRATION, (Level)serverLevel), 3);
                    }
                    drowned.equipItemIfPossible(helmet);
                    drowned.setDropChance(EquipmentSlot.HEAD, 0.15f);
                    if (isStrong) {
                        ItemStack trident = Items.TRIDENT.getDefaultInstance();
                        if ((double)serverLevel.getRandom().nextFloat() < 0.25) {
                            trident.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.CHANNELING, (Level)serverLevel), 1);
                        } else if ((double)serverLevel.getRandom().nextFloat() < 0.25) {
                            trident.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.LOYALTY, (Level)serverLevel), 1);
                        } else if ((double)serverLevel.getRandom().nextFloat() < 0.25) {
                            trident.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.IMPALING, (Level)serverLevel), 1);
                        } else {
                            trident.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.RIPTIDE, (Level)serverLevel), 1);
                        }
                        drowned.setItemSlot(EquipmentSlot.MAINHAND, trident);
                        drowned.setDropChance(EquipmentSlot.MAINHAND, 0.9f);
                    } else {
                        if (drowned.getMainHandItem().is(Items.TRIDENT)) {
                            drowned.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        } else if (drowned.getOffhandItem().is(Items.TRIDENT)) {
                            drowned.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                        }
                        drowned.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, Integer.MAX_VALUE, 4, false, false, true));
                    }
                    if (drowned.getMainHandItem().isEmpty() && serverLevel.getRandom().nextFloat() < 0.3f) {
                        drowned.setItemSlot(EquipmentSlot.MAINHAND, bonusItem);
                        drowned.setDropChance(EquipmentSlot.MAINHAND, 2.0f);
                    } else if (drowned.getOffhandItem().isEmpty() && serverLevel.getRandom().nextFloat() < 0.3f) {
                        drowned.setItemSlot(EquipmentSlot.OFFHAND, bonusItem);
                        drowned.setDropChance(EquipmentSlot.OFFHAND, 2.0f);
                    }
                }
            }
        }
    }

    public void handleGiantBubbles(ServerLevel serverLevel, BlockPos blockPos) {
        int bubbleMoveTime;
        if (!BzGeneralConfigs.blueArenaBubblesMechanic) {
            return;
        }
        long gameTime = serverLevel.getGameTime();
        if (gameTime % (long)(bubbleMoveTime = 23) == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int offSetBubble = direction.getAxis() == Direction.Axis.X ? 0 : 8;
                int currentProgress = (int)((gameTime / (long)bubbleMoveTime + (long)offSetBubble) % 16L);
                BlockPos bubbleCenter = blockPos.offset(direction.getStepX() * 10, currentProgress - 8, direction.getStepZ() * 10);
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int y = -2; y <= 1; ++y) {
                    mutableBlockPos.set((Vec3i)bubbleCenter).move(Direction.UP, y);
                    if (mutableBlockPos.getY() < blockPos.getY() - 5 || mutableBlockPos.getY() > blockPos.getY() + 5) continue;
                    for (int x = -1; x <= 1; ++x) {
                        mutableBlockPos.move(Direction.EAST, x);
                        for (int z = -1; z <= 1; ++z) {
                            mutableBlockPos.move(Direction.SOUTH, z);
                            if (y == -2) {
                                serverLevel.setBlock((BlockPos)mutableBlockPos, Blocks.WATER.defaultBlockState(), 2);
                            } else {
                                serverLevel.setBlock((BlockPos)mutableBlockPos, ((Block)BzBlocks.DENSE_BUBBLE_BLOCK.get()).defaultBlockState(), 2);
                            }
                            mutableBlockPos.move(Direction.SOUTH, -z);
                        }
                        mutableBlockPos.move(Direction.EAST, -x);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CALMING_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CALMING_EVENT.get()).getLocation(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

