/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.datamanagers.CrystallineFlowerDataManager;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.CrystallineFlowerData;
import com.telepathicgrunt.the_bumblezone.menus.CrystallineFlowerMenu;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ExperienceOrbAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystallineFlower
extends BaseEntityBlock {
    public static final MapCodec<CrystallineFlower> CODEC = Block.simpleCodec(CrystallineFlower::new);
    public static final BooleanProperty FLOWER = BooleanProperty.create((String)"flower");
    protected final VoxelShape shapeFlower = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected final VoxelShape shapeBody = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.the_bumblezone.crystalline_flower");
    private static final Component OCCUPIED_CRYSTALLINE_FLOWER_TEXT = Component.translatable((String)"system.the_bumblezone.occupied_crystalline_flower");

    public CrystallineFlower() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).lightLevel(blockState -> (Boolean)blockState.getValue((Property)FLOWER) != false ? 7 : 0).noCollission().noOcclusion().strength(0.4f, 0.01f).pushReaction(PushReaction.DESTROY).sound((SoundType)BzSounds.HONEY_CRYSTALS_TYPE));
    }

    public CrystallineFlower(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FLOWER, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends CrystallineFlower> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return blockstate.hasProperty((Property)FLOWER) && (Boolean)blockstate.getValue((Property)FLOWER) != false ? this.shapeFlower : this.shapeBody;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[0]).add(new Property[]{FLOWER});
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BzBlockEntities.CRYSTALLINE_FLOWER.get()).create(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        VoxelShape voxelShape = this.getShape(state, (BlockGetter)level, pos, null).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!Shapes.joinIsNotEmpty((VoxelShape)voxelShape, (VoxelShape)Shapes.create((AABB)entity.getBoundingBox()), (BooleanOp)BooleanOp.AND)) return;
        if (level.isClientSide()) {
            return;
        }
        if (entity instanceof LivingEntity && !BeeAggression.isBeelikeEntity((Entity)(livingEntity = (LivingEntity)entity))) {
            float fallDistance = entity.fallDistance;
            livingEntity.makeStuckInBlock(state, new Vec3((double)0.95f, 2.0, (double)0.95f));
            entity.fallDistance = fallDistance;
            if (level.isClientSide()) return;
            if (livingEntity.xOld == livingEntity.getX() && livingEntity.yOld == livingEntity.getY()) {
                if (livingEntity.zOld == livingEntity.getZ()) return;
            }
            double xDiff = Math.abs(livingEntity.getX() - livingEntity.xOld);
            double yDiff = Math.abs(livingEntity.getY() - livingEntity.yOld);
            double zDiff = Math.abs(livingEntity.getZ() - livingEntity.zOld);
            if (!(xDiff >= (double)0.001f) && !(yDiff >= 0.75)) {
                if (!(zDiff >= (double)0.001f)) return;
            }
            livingEntity.hurt(level.damageSources().source(BzDamageSources.CRYSTALLINE_FLOWER_TYPE), 1.5f);
            if (!livingEntity.isDeadOrDying()) return;
            if (livingEntity.wasExperienceConsumed()) return;
            if (((LivingEntityAccessor)livingEntity).bumblezone$callIsAlwaysExperienceDropper()) return;
            if (!livingEntity.shouldDropExperience()) return;
            if (!level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) return;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            if (crystallineFlowerBlockEntity.isMaxTier()) return;
            int reward = PlatformService.INSTANCE.getXpDrop(livingEntity, null, livingEntity.getExperienceReward((ServerLevel)level, null));
            ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)livingEntity.position(), (int)reward);
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (BzGeneralConfigs.crystallineFlowerConsumeItemEntities) {
                ItemStack stack = itemEntity.getItem();
                if (stack.is(BzTags.CAN_BE_ENCHANTED_ITEMS)) return;
                if (CrystallineFlowerDataManager.CRYSTALLINE_FLOWER_DATA_MANAGER.disallowConsume.contains(stack.getItem())) return;
                if (stack.is((Item)BzItems.HONEY_CRYSTAL_SHARDS.get())) {
                    return;
                }
                int bottomY = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
                BlockPos bottomPos = pos.below(bottomY);
                BlockEntity blockEntity = level.getBlockEntity(bottomPos);
                if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (crystallineFlowerBlockEntity.isMaxTier()) return;
                int tiersToMax = 7 - crystallineFlowerBlockEntity.getXpTier();
                int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)level, crystallineFlowerBlockEntity.getBlockPos());
                List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, level, crystallineFlowerBlockEntity.getBlockPos().above(topBlock + 1));
                int xpPerCount = CrystallineFlower.getXpPerItem(stack);
                int itemCount = stack.getCount();
                int xpForStack = itemCount * xpPerCount;
                int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
                int xpGranted = Math.min(xpToHighestAvailableTier, xpForStack);
                int consumedItemCount = (int)Math.ceil((float)xpGranted / (float)xpPerCount);
                if (consumedItemCount == 0) {
                    return;
                }
                crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
                stack.shrink(consumedItemCount);
                if (consumedItemCount >= itemCount) {
                    itemEntity.discard();
                }
                if (!(level instanceof ServerLevel)) return;
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnConsumeParticles((Level)serverLevel, itemEntity.position(), level.random, consumedItemCount / 3 + 5);
                return;
            }
        }
        if (!(entity instanceof ExperienceOrb)) return;
        ExperienceOrb experienceOrb = (ExperienceOrb)entity;
        if (!BzGeneralConfigs.crystallineFlowerConsumeExperienceOrbEntities) return;
        int bottomY = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPos = pos.below(bottomY);
        BlockEntity blockEntity = level.getBlockEntity(bottomPos);
        if (!(blockEntity instanceof CrystallineFlowerBlockEntity)) return;
        CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
        if (crystallineFlowerBlockEntity.isMaxTier()) return;
        int tiersToMax = 7 - crystallineFlowerBlockEntity.getXpTier();
        int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)level, crystallineFlowerBlockEntity.getBlockPos());
        List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, level, crystallineFlowerBlockEntity.getBlockPos().above(topBlock + 1));
        int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
        int xpGranted = Math.min(xpToHighestAvailableTier, experienceOrb.getValue());
        crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
        ((ExperienceOrbAccessor)experienceOrb).bumblezone$setValue(experienceOrb.getValue() - xpGranted);
        if (experienceOrb.getValue() <= 0) {
            experienceOrb.discard();
        }
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)level;
        this.spawnConsumeParticles((Level)serverLevel, experienceOrb.position(), level.random, 3);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            if (level.players().stream().noneMatch(p -> {
                AbstractContainerMenu patt0$temp = p.containerMenu;
                if (!(patt0$temp instanceof CrystallineFlowerMenu)) return false;
                CrystallineFlowerMenu crystallineFlowerMenu = (CrystallineFlowerMenu)patt0$temp;
                if (crystallineFlowerMenu.crystallineFlowerBlockEntity == null) return false;
                if (!crystallineFlowerMenu.crystallineFlowerBlockEntity.getUUID().equals(crystallineFlowerBlockEntity.getUUID())) return false;
                return true;
            })) {
                if (level.isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                player.openMenu(state.getMenuProvider(level, pos));
                player.awardStat((ResourceLocation)BzStats.INTERACT_WITH_CRYSTALLINE_FLOWER_RL.get());
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage(OCCUPIED_CRYSTALLINE_FLOWER_TEXT, true);
            }
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            crystallineFlowerBlockEntity.setPillar(crystallineFlowerBlockEntity.getXpTier());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos().below()).is((Block)BzBlocks.CRYSTALLINE_FLOWER.get())) {
            return null;
        }
        BlockState defaultState = super.getStateForPlacement(context);
        return defaultState == null ? null : (BlockState)defaultState.setValue((Property)FLOWER, (Comparable)Boolean.valueOf(CrystallineFlower.isFlowerSpot(context.getLevel(), context.getClickedPos())));
    }

    public void neighborChanged(BlockState blockstate, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (this.canSurvive(blockstate, (LevelReader)level, pos)) {
            boolean flowerSpot = CrystallineFlower.isFlowerSpot(level, pos);
            if (flowerSpot != (Boolean)blockstate.getValue((Property)FLOWER)) {
                level.setBlock(pos, (BlockState)blockstate.setValue((Property)FLOWER, (Comparable)Boolean.valueOf(flowerSpot)), 3);
            }
        } else {
            level.destroyBlock(pos, blockstate.hasProperty((Property)FLOWER) && (Boolean)blockstate.getValue((Property)FLOWER) != false, null, 1);
        }
        super.neighborChanged(blockstate, level, pos, block, fromPos, notify);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        boolean isBelowValid = belowState.is(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON) && belowState.isFaceSturdy((BlockGetter)level, pos, Direction.UP) || belowState.is((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
        int flowerBlockAbove = CrystallineFlower.flowerHeightAbove(level, pos);
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow(level, pos);
        BlockEntity operatingBE = level.getBlockEntity(pos.below(flowerBlockBelow));
        if (operatingBE instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)operatingBE;
            return isBelowValid && flowerBlockBelow + flowerBlockAbove + 1 == crystallineFlowerBlockEntity.getXpTier();
        }
        return isBelowValid && flowerBlockBelow + flowerBlockAbove + 1 <= 7;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.hasProperty((Property)FLOWER) && ((Boolean)state.getValue((Property)FLOWER)).booleanValue()) {
            return super.getDrops(state, builder);
        }
        return new ArrayList<ItemStack>();
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPos = pos.below(flowerBlockBelow);
        BlockEntity blockEntity = level.getBlockEntity(bottomPos);
        if (blockEntity instanceof CrystallineFlowerBlockEntity) {
            CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
            return crystallineFlowerBlockEntity.getXpTier();
        }
        return 0;
    }

    public static boolean isFlowerSpot(Level level, BlockPos pos) {
        return !level.getBlockState(pos.above()).is((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
    }

    public static boolean isBottomSpot(Level level, BlockPos pos) {
        return !level.getBlockState(pos.below()).is((Block)BzBlocks.CRYSTALLINE_FLOWER.get());
    }

    public static int flowerTotalHeight(LevelReader level, BlockPos pos) {
        return CrystallineFlower.flowerHeightBelow(level, pos) + CrystallineFlower.flowerHeightAbove(level, pos) + 1;
    }

    public static int flowerHeightBelow(LevelReader level, BlockPos pos) {
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState currentState = level.getBlockState((BlockPos)mutable.set((Vec3i)pos.below()));
        while (currentState.is((Block)BzBlocks.CRYSTALLINE_FLOWER.get()) && mutable.getY() >= level.getMinBuildHeight()) {
            ++i;
            mutable.move(Direction.DOWN);
            currentState = level.getBlockState((BlockPos)mutable);
        }
        return i;
    }

    public static int flowerHeightAbove(LevelReader level, BlockPos pos) {
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState currentState = level.getBlockState((BlockPos)mutable.set((Vec3i)pos.above()));
        while (currentState.is((Block)BzBlocks.CRYSTALLINE_FLOWER.get()) && mutable.getY() < level.getMaxBuildHeight()) {
            ++i;
            mutable.move(Direction.UP);
            currentState = level.getBlockState((BlockPos)mutable);
        }
        return i;
    }

    public static List<Boolean> getObstructions(int scanArea, Level level, BlockPos pos) {
        ArrayList<Boolean> obstructions = new ArrayList<Boolean>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)pos);
        for (int i = 0; i < scanArea; ++i) {
            if (mutable.getY() >= level.getMaxBuildHeight()) {
                obstructions.add(true);
            } else {
                BlockState currentState = level.getBlockState((BlockPos)mutable);
                if (!(currentState.isAir() || currentState.is(BzTags.AIR_LIKE) || currentState.is((Block)BzBlocks.CRYSTALLINE_FLOWER.get()))) {
                    obstructions.add(true);
                } else {
                    obstructions.add(false);
                }
            }
            mutable.move(Direction.UP);
        }
        return obstructions;
    }

    public static int getXpPerItem(ItemStack stack) {
        if (CrystallineFlowerDataManager.CRYSTALLINE_FLOWER_DATA_MANAGER.disallowConsume.contains(stack.getItem())) {
            return 0;
        }
        Pair<Integer, Boolean> xpValue = CrystallineFlowerDataManager.CRYSTALLINE_FLOWER_DATA_MANAGER.itemToXp.get(stack.getItem());
        if (xpValue != null) {
            return (Boolean)xpValue.getSecond() != false ? Integer.MAX_VALUE : (Integer)xpValue.getFirst();
        }
        return CrystallineFlowerDataManager.CRYSTALLINE_FLOWER_DATA_MANAGER.allowNormalConsumption ? 1 : 0;
    }

    public static int getXpToHighestAvailableTier(CrystallineFlowerBlockEntity crystallineFlowerBlockEntity, int tiersToMax, List<Boolean> obstructedAbove) {
        int xpToHighestAvailableTier = 0;
        for (int i = 1; i <= tiersToMax; ++i) {
            int xpToDesiredTier = crystallineFlowerBlockEntity.getXpForNextTiers(i);
            if (i - 1 < obstructedAbove.size() && obstructedAbove.get(i - 1).booleanValue()) {
                xpToHighestAvailableTier = xpToDesiredTier - 1;
                break;
            }
            xpToHighestAvailableTier = xpToDesiredTier;
        }
        return xpToHighestAvailableTier;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        int flowerBlockBelow = CrystallineFlower.flowerHeightBelow((LevelReader)level, pos);
        BlockPos bottomPlant = pos.below(flowerBlockBelow);
        BlockEntity blockEntity = level.getBlockEntity(bottomPlant);
        CrystallineFlowerBlockEntity finalCrystallineFlowerBlockEntity = blockEntity instanceof CrystallineFlowerBlockEntity ? (CrystallineFlowerBlockEntity)blockEntity : null;
        return new SimpleMenuProvider((containerId, inventory, player) -> new CrystallineFlowerMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos.below(flowerBlockBelow)), finalCrystallineFlowerBlockEntity), CONTAINER_TITLE);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(itemStack, tooltipContext, tooltip, flag);
        CrystallineFlowerData flowerData = (CrystallineFlowerData)itemStack.getOrDefault((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)new CrystallineFlowerData());
        if (flowerData.uuid().compareTo(CrystallineFlowerData.DEFAULT_UUID) != 0 && flowerData.tier() != 0) {
            tooltip.add((Component)Component.translatable((String)"item.the_bumblezone.crystalline_flower_info_1", (Object[])new Object[]{flowerData.tier()}).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.translatable((String)"item.the_bumblezone.crystalline_flower_info_2", (Object[])new Object[]{flowerData.experience()}).withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC));
        }
    }

    private void spawnConsumeParticles(Level world, Vec3 position, RandomSource random, int particleCount) {
        ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, position.x(), position.y() + 0.5, position.z(), particleCount, random.nextDouble() / 8.0 + 0.2, random.nextDouble() / 8.0 + 0.2, random.nextDouble() / 8.0 + 0.2, 0.1);
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        boolean flower = (Boolean)blockState.getValue((Property)FLOWER);
        float f = random.nextFloat();
        float f2 = flower ? 0.15f : 0.05f;
        if (f < f2) {
            this.spawnSparkleParticles(world, position, random, flower);
        }
        if (flower) {
            world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)position.getX() + 0.5, (double)position.getY() + 0.1, (double)position.getZ() + 0.5, random.nextGaussian() * 0.005, random.nextGaussian() * 0.005 + 0.005, random.nextGaussian() * 0.005);
        }
    }

    private void spawnSparkleParticles(Level world, BlockPos position, RandomSource random, boolean flower) {
        double z;
        double y;
        double x;
        int min = flower ? 1 : 3;
        int max = flower ? 15 : 13;
        double minRatio = (double)min / 16.0;
        if (flower) {
            int chosenFace = random.nextInt(3);
            boolean xB = random.nextBoolean();
            boolean yB = random.nextBoolean();
            boolean zB = random.nextBoolean();
            x = random.nextDouble() + (double)(xB ? min : max) * (chosenFace != 0 ? random.nextDouble() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 0 ? min : 0);
            y = random.nextDouble() + (double)(yB ? 0 : 9) * (chosenFace != 1 ? random.nextDouble() : 1.0);
            z = random.nextDouble() + (double)(zB ? min : max) * (chosenFace != 2 ? random.nextDouble() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 2 ? min : 0);
        } else {
            int chosenFace = random.nextInt(2);
            boolean xB = random.nextBoolean();
            boolean zB = random.nextBoolean();
            x = random.nextDouble() + (double)(xB ? min : max) * (chosenFace != 0 ? random.nextDouble() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 0 ? min : 0);
            y = random.nextDouble() * 16.0;
            z = random.nextDouble() + (double)(zB ? min : max) * (chosenFace != 1 ? random.nextDouble() * (1.0 - minRatio) : 1.0) + (double)(chosenFace != 1 ? min : 0);
        }
        world.addParticle((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), x / 16.0 + (double)position.getX(), y / 16.0 + (double)position.getY(), z / 16.0 + (double)position.getZ(), 0.0, 0.0, 0.0);
    }
}

