/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class StoneWorkGenerateRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<StoneWorkGenerateRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ItemStack.CODEC.fieldOf("output").forGetter(o -> o.output), (App)Codec.INT.fieldOf("waterNeed").forGetter(o -> o.waterNeed), (App)Codec.INT.fieldOf("lavaNeed").forGetter(o -> o.lavaNeed), (App)Codec.INT.fieldOf("waterConsume").forGetter(o -> o.waterConsume), (App)Codec.INT.fieldOf("lavaConsume").forGetter(o -> o.lavaConsume)).apply((Applicative)in, StoneWorkGenerateRecipe::new));
    public ItemStack output;
    public int waterNeed;
    public int lavaNeed;
    public int waterConsume;
    public int lavaConsume;

    public StoneWorkGenerateRecipe(ItemStack output, int waterNeed, int lavaNeed, int waterConsume, int lavaConsume) {
        this.output = output;
        this.waterNeed = waterNeed;
        this.lavaNeed = lavaNeed;
        this.waterConsume = waterConsume;
        this.lavaConsume = lavaConsume;
    }

    public StoneWorkGenerateRecipe() {
    }

    public static void init(RecipeOutput output) {
        StoneWorkGenerateRecipe.createRecipe(output, "cobblestone", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.COBBLESTONE), 1000, 1000, 0, 0));
        StoneWorkGenerateRecipe.createRecipe(output, "netherrack", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.NETHERRACK), 250, 400, 250, 200));
        StoneWorkGenerateRecipe.createRecipe(output, "obsidian", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.OBSIDIAN), 1000, 1000, 0, 1000));
        StoneWorkGenerateRecipe.createRecipe(output, "granite", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.GRANITE), 200, 200, 200, 200));
        StoneWorkGenerateRecipe.createRecipe(output, "diorite", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.DIORITE), 200, 250, 200, 250));
        StoneWorkGenerateRecipe.createRecipe(output, "andesite", new StoneWorkGenerateRecipe(new ItemStack((ItemLike)Blocks.ANDESITE), 300, 300, 300, 300));
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, StoneWorkGenerateRecipe recipe) {
        ResourceLocation rl = StoneWorkGenerateRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("stonework_generate/" + key));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.STONEWORK_GENERATE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get();
    }

    public boolean canIncrease(FluidTank fluidTank, FluidTank fluidTank2) {
        return fluidTank.getFluidAmount() >= this.waterNeed && fluidTank2.getFluidAmount() >= this.lavaNeed;
    }

    public void consume(FluidTankComponent fluidTank, FluidTankComponent fluidTank2) {
        fluidTank.drainForced(this.waterConsume, IFluidHandler.FluidAction.EXECUTE);
        fluidTank2.drainForced(this.lavaConsume, IFluidHandler.FluidAction.EXECUTE);
    }
}

