/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class DissolutionChamberRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<DissolutionChamberRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.listOf(0, 8).fieldOf("input").forGetter(o -> o.input), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("inputFluid").forGetter(o -> o.inputFluid), (App)Codec.INT.fieldOf("processingTime").forGetter(o -> o.processingTime), (App)ItemStack.CODEC.optionalFieldOf("output").forGetter(o -> o.output), (App)FluidStack.CODEC.optionalFieldOf("outputFluid").forGetter(o -> o.outputFluid)).apply((Applicative)in, DissolutionChamberRecipe::new));
    public List<Ingredient> input;
    public SizedFluidIngredient inputFluid;
    public int processingTime;
    public Optional<ItemStack> output;
    public Optional<FluidStack> outputFluid;

    public DissolutionChamberRecipe(List<Ingredient> input, SizedFluidIngredient inputFluid, int processingTime, Optional<ItemStack> output, Optional<FluidStack> outputFluid) {
        this.input = input;
        this.inputFluid = inputFluid;
        this.processingTime = processingTime;
        this.output = output;
        this.outputFluid = outputFluid;
    }

    public DissolutionChamberRecipe(List<Ingredient> input, FluidStack inputFluid, int processingTime, Optional<ItemStack> output, Optional<FluidStack> outputFluid) {
        this.input = input;
        this.inputFluid = SizedFluidIngredient.of((FluidStack)inputFluid);
        this.processingTime = processingTime;
        this.output = output;
        this.outputFluid = outputFluid;
    }

    public DissolutionChamberRecipe() {
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, DissolutionChamberRecipe recipe) {
        ResourceLocation rl = DissolutionChamberRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        ArrayList<ItemExistsCondition> conditions = new ArrayList<ItemExistsCondition>();
        if (recipe.output.isPresent()) {
            conditions.add(new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)recipe.output.get().getItem())));
        }
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, conditions.toArray(new ICondition[conditions.size()]));
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("dissolution_chamber/" + key));
    }

    public boolean matches(IItemHandler handler, FluidTankComponent tank) {
        if (this.input == null || tank == null || this.inputFluid == null) {
            return false;
        }
        ArrayList<ItemStack> handlerItems = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            handlerItems.add(handler.getStackInSlot(i).copy());
        }
        for (Ingredient ingredient : this.input) {
            boolean found = false;
            for (ItemStack stack : ingredient.getItems()) {
                int i;
                for (i = 0; i < handlerItems.size(); ++i) {
                    if (!ItemStack.isSameItem((ItemStack)((ItemStack)handlerItems.get(i)), (ItemStack)stack)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                handlerItems.remove(i);
                break;
            }
            if (found) continue;
            return false;
        }
        boolean flag = this.inputFluid.test(tank.getFluid());
        return handlerItems.isEmpty() && flag && tank.drainForced(tank.getFluid().copyWithAmount(this.inputFluid.amount()), IFluidHandler.FluidAction.SIMULATE).getAmount() == this.inputFluid.amount();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.orElse(ItemStack.EMPTY).copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModuleCore.DISSOLUTION_CHAMBER.getBlock());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.DISSOLUTION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.DISSOLUTION_TYPE.get();
    }
}

