/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.emi.recipe;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.emi.recipe.CustomEmiRecipe;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorEmiRecipe
extends CustomEmiRecipe {
    private final MycelialGeneratorRecipe recipe;
    private final IMycelialGeneratorType type;

    public MycelialGeneratorEmiRecipe(IMycelialGeneratorType type, MycelialGeneratorRecipe recipe, EmiRecipeCategory category) {
        super(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("emi_" + type.getName().toLowerCase() + "_" + UUID.randomUUID().toString())), category, MycelialGeneratorEmiRecipe.transformRecipe(recipe), MycelialGeneratorEmiRecipe.fromOutput(EmiStack.EMPTY));
        this.type = type;
        this.recipe = recipe;
    }

    private static List<EmiIngredient> transformRecipe(MycelialGeneratorRecipe recipe) {
        ArrayList<EmiIngredient> list = new ArrayList<EmiIngredient>();
        recipe.getInputItems().forEach(ingredients -> list.add(EmiIngredient.of(ingredients.stream().map(EmiIngredient::of).toList())));
        recipe.getFluidItems().forEach(fluidStacks -> {
            if (!fluidStacks.isEmpty()) {
                list.add((EmiIngredient)NeoForgeEmiStack.of((FluidStack)((FluidStack)fluidStacks.get(0))));
            }
        });
        return list;
    }

    public int getDisplayWidth() {
        return 20 * this.type.getInputs().length + 110;
    }

    public int getDisplayHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9 * 3;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            IMycelialGeneratorType.Input input = this.type.getInputs()[i];
            if (input == IMycelialGeneratorType.Input.SLOT) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                widgets.addSlot(this.getInputs().get(i), 20 * i, 9 / 2);
                continue;
            }
            if (input != IMycelialGeneratorType.Input.TANK) continue;
            Objects.requireNonNull(Minecraft.getInstance().font);
            widgets.addTank(this.getInputs().get(i), 20 * i + 2, 2 + 9 / 2, 14, 15, 1000).drawBack(false);
        }
        widgets.addDrawable(0, 0, 0, 0, (draw, mouseX, mouseY, delta) -> {
            for (int i = 0; i < this.type.getInputs().length; ++i) {
                if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                    int finalI = i;
                    Screen screen = Minecraft.getInstance().screen;
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    SlotsScreenAddon.drawAsset((GuiGraphics)draw, (Screen)screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)(20 * i), (int)(9 / 2), (int)0, (int)0, (int)1, integer -> Pair.of((Object)1, (Object)1), integer -> ItemStack.EMPTY, (boolean)true, integer -> new Color(this.type.getInputColors()[finalI].getFireworkColor()), integer -> true, (int)1);
                    continue;
                }
                if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
                Screen screen = Minecraft.getInstance().screen;
                IAsset iAsset = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL);
                Objects.requireNonNull(Minecraft.getInstance().font);
                AssetUtil.drawAsset((GuiGraphics)draw, (Screen)screen, (IAsset)iAsset, (int)(20 * i), (int)(9 / 2));
            }
            int x = 20 * this.type.getInputs().length + 3;
            Font font = Minecraft.getInstance().font;
            String string = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.time").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + new DecimalFormat().format((double)this.recipe.getTicks() / 20.0) + String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"tooltip.industrialforegoing.sec_short").getString();
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.drawString(font, string, x, 9 * 0, -1, false);
            Font font2 = Minecraft.getInstance().font;
            String string2 = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.production").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + this.recipe.getPowerTick() + String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"tooltip.industrialforegoing.fe_t").getString();
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.drawString(font2, string2, x, 9 * 1, -1, false);
            Font font3 = Minecraft.getInstance().font;
            String string3 = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.total").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + new DecimalFormat().format(this.recipe.getTicks() * this.recipe.getPowerTick()) + String.valueOf(ChatFormatting.DARK_GRAY) + " FE";
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.drawString(font3, string3, x, 9 * 2, -1, false);
        });
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

