/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.module;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.IndustrialBlockItem;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBlinkingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBouncingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDetectorUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDroppingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorExtractionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorInsertionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorSplittingUpgrade;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterFluidType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterItemType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterWorldType;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.item.ItemConveyorUpgrade;
import com.buuz135.industrial.item.ItemTransporterType;
import com.buuz135.industrial.module.IModule;
import com.buuz135.industrial.proxy.client.model.ConveyorBlockModel;
import com.buuz135.industrial.proxy.client.model.TransporterBlockModel;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class ModuleTransportStorage
implements IModule {
    public static TitaniumTab TAB_TRANSPORT = new TitaniumTab(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"transport"));
    public static ConveyorUpgradeFactory upgrade_extraction = new ConveyorExtractionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_insertion = new ConveyorInsertionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_detector = new ConveyorDetectorUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_bouncing = new ConveyorBouncingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_dropping = new ConveyorDroppingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_blinking = new ConveyorBlinkingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_splitting = new ConveyorSplittingUpgrade.Factory();
    public static BlockWithTile CONVEYOR = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem("conveyor", () -> new ConveyorBlock(TAB_TRANSPORT), blockRegistryObject -> () -> new IndustrialBlockItem((Block)blockRegistryObject.get(), TAB_TRANSPORT), TAB_TRANSPORT);
    public static HashMap<ResourceLocation, BakedModel> CONVEYOR_UPGRADES_CACHE = new HashMap();
    public static TransporterTypeFactory ITEM_TRANSPORTER = new TransporterItemType.Factory();
    public static TransporterTypeFactory FLUID_TRANSPORTER = new TransporterFluidType.Factory();
    public static TransporterTypeFactory WORLD_TRANSPORTER = new TransporterWorldType.Factory();
    public static BlockWithTile TRANSPORTER = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem("transporter", () -> new TransporterBlock(), blockRegistryObject -> () -> new TransporterBlock.Item((Block)blockRegistryObject.get(), TAB_TRANSPORT), TAB_TRANSPORT);
    public static HashMap<ResourceLocation, BakedModel> TRANSPORTER_CACHE = new HashMap();

    @Override
    public void generateFeatures(DeferredRegistryHelper registryHelper) {
        ContainerConveyor.TYPE = registryHelper.registerGeneric(Registries.MENU, "conveyor", () -> IMenuTypeExtension.create(ContainerConveyor::new));
        ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> registryHelper.registerGeneric(Registries.ITEM, "conveyor_" + conveyorUpgradeFactory.getName() + "_upgrade", () -> new ItemConveyorUpgrade((ConveyorUpgradeFactory)conveyorUpgradeFactory, TAB_TRANSPORT)));
        ContainerTransporter.TYPE = registryHelper.registerGeneric(Registries.MENU, "transporter", () -> IMenuTypeExtension.create(ContainerTransporter::new));
        TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> registryHelper.registerGeneric(Registries.ITEM, transporterTypeFactory.getName() + "_transporter_type", () -> new ItemTransporterType((TransporterTypeFactory)transporterTypeFactory, TAB_TRANSPORT)));
        if (FMLEnvironment.dist.isClient()) {
            this.onClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void bakingCompleted(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        ModelBakery modelBakery = event.getModelBakery();
        for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
            for (Direction upgradeFacing : transporterTypeFactory.getValidFacings()) {
                for (TransporterTypeFactory.TransporterAction actions : TransporterTypeFactory.TransporterAction.values()) {
                    try {
                        ResourceLocation resourceLocation = transporterTypeFactory.getModel(upgradeFacing, actions);
                        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, "standalone");
                        UnbakedModel unbakedModel = event.getModelBakery().getModel(resourceLocation);
                        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.sprite(), modelResourceLocation);
                        BakedModel bakedModel = unbakedModel.bake((ModelBaker)baker, Material::sprite, (ModelState)new SimpleModelState(Transformation.identity()));
                        TRANSPORTER_CACHE.put(resourceLocation, bakedModel);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
            for (Direction upgradeFacing : conveyorUpgradeFactory.getValidFacings()) {
                for (Direction conveyorFacing : ConveyorBlock.FACING.getPossibleValues()) {
                    try {
                        ResourceLocation resourceLocation = conveyorUpgradeFactory.getModel(upgradeFacing, conveyorFacing);
                        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, "standalone");
                        UnbakedModel unbakedModel = event.getModelBakery().getModel(resourceLocation);
                        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.sprite(), modelResourceLocation);
                        CONVEYOR_UPGRADES_CACHE.put(resourceLocation, unbakedModel.bake((ModelBaker)baker, Material::sprite, (ModelState)new SimpleModelState(Transformation.identity())));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void modifyBakingResult(ModelEvent.ModifyBakingResult event) {
        for (ModelResourceLocation resourceLocation : event.getModels().keySet()) {
            if (!resourceLocation.id().getNamespace().equals("industrialforegoing")) continue;
            if (resourceLocation.id().getPath().contains("transporter") && !resourceLocation.id().getPath().contains("transporters/") && !resourceLocation.id().getPath().contains("type")) {
                event.getModels().put(resourceLocation, new TransporterBlockModel((BakedModel)event.getModels().get(resourceLocation)));
            }
            if (!resourceLocation.id().getPath().contains("conveyor") || resourceLocation.id().getPath().contains("upgrade")) continue;
            event.getModels().put(resourceLocation, new ConveyorBlockModel((BakedModel)event.getModels().get(resourceLocation)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClient() {
        EventManager.mod(ModelEvent.BakingCompleted.class).process(this::bakingCompleted).subscribe();
        EventManager.mod(ModelEvent.ModifyBakingResult.class).process(this::modifyBakingResult).subscribe();
    }
}

