/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.timcore.influence;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.timcore.Debugger;
import us.timinc.mc.cobblemon.timcore.LimitedList;
import us.timinc.mc.cobblemon.timcore.TimCore;
import us.timinc.mc.cobblemon.timcore.event.ReloadConfigEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lus/timinc/mc/cobblemon/timcore/influence/PreventSpawnsInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "detail", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "affectSpawnable", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)Z", "Companion", "common"})
public final class PreventSpawnsInfluence
implements SpawningInfluence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<String, Companion.CacheResult> cache = new ConcurrentHashMap();
    @NotNull
    private static final LinkedBlockingQueue<Pair<String, PokemonSpawnDetail>> detailQueue = new LinkedBlockingQueue();
    @Nullable
    private static Thread runnerThread;

    public boolean affectSpawnable(@NotNull SpawnDetail detail, @NotNull SpawnablePosition spawnablePosition) {
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        if (!(detail instanceof PokemonSpawnDetail)) {
            return true;
        }
        if (((TimCore.Config)TimCore.INSTANCE.getConfig()).getSpawnBlacklistMatcher().isEmpty() && ((TimCore.Config)TimCore.INSTANCE.getConfig()).getSpawnWhitelistMatcher().isEmpty()) {
            return true;
        }
        Debugger.Case debugger = TimCore.INSTANCE.getDebugger().getCaseDebugger("PreventSpawns:" + detail.getId());
        Companion.CacheResult cached = cache.get(detail.getId());
        if (cached != null && cached != Companion.CacheResult.COMPUTING) {
            return cached.getValue();
        }
        Companion.CacheResult previous = cache.putIfAbsent(detail.getId(), Companion.CacheResult.COMPUTING);
        if (previous == null) {
            detailQueue.offer((Pair<String, PokemonSpawnDetail>)TuplesKt.to((Object)detail.getId(), (Object)detail));
            Debugger.debug$default(debugger, "No cached value, queued for calculation.", false, 2, null);
        }
        return false;
    }

    private static final Unit _init_$lambda$0(ReloadConfigEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        cache.clear();
        detailQueue.clear();
        Debugger.debug$default(TimCore.INSTANCE.getDebugger(), "Cleared the prevent spawns cache due to mod reload.", false, 2, null);
        return Unit.INSTANCE;
    }

    static {
        Observable.subscribe$default((Observable)((Observable)TimCore.INSTANCE.RELOAD_CONFIG), null, PreventSpawnsInfluence::_init_$lambda$0, (int)1, null);
        PreventSpawnsInfluence.Companion.startRunner();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR&\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lus/timinc/mc/cobblemon/timcore/influence/PreventSpawnsInfluence$Companion;", "", "<init>", "()V", "", "startRunner", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lus/timinc/mc/cobblemon/timcore/influence/PreventSpawnsInfluence$Companion$CacheResult;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnDetail;", "detailQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/lang/Thread;", "runnerThread", "Ljava/lang/Thread;", "CacheResult", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final void startRunner() {
            runnerThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"PreventSpawnsWorker", (int)0, Companion::startRunner$lambda$0, (int)21, null);
        }

        private static final Unit startRunner$lambda$0() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    boolean bl;
                    Pair pair = (Pair)detailQueue.take();
                    String detailId = (String)pair.component1();
                    PokemonSpawnDetail spawnDetail = (PokemonSpawnDetail)pair.component2();
                    Debugger.Case debugger = TimCore.INSTANCE.getDebugger().getCaseDebugger("PreventSpawns:" + detailId);
                    Debugger.debug$default(debugger, "Processing queued spawn calculation.", false, 2, null);
                    try {
                        bl = LimitedList.PokemonMatcherList.INSTANCE.matchesList(PokemonProperties.create$default((PokemonProperties)spawnDetail.getPokemon(), null, (int)1, null), ((TimCore.Config)TimCore.INSTANCE.getConfig()).getSpawnWhitelistMatcher(), ((TimCore.Config)TimCore.INSTANCE.getConfig()).getSpawnBlacklistMatcher());
                    }
                    catch (Exception e) {
                        Debugger.debug$default(debugger, "Error processing spawn: " + e.getMessage(), false, 2, null);
                        bl = false;
                    }
                    boolean result = bl;
                    ((Map)cache).put(detailId, result ? CacheResult.YES : CacheResult.NO);
                    Debugger.debug$default(debugger, "Calculated as " + result + ".", false, 2, null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lus/timinc/mc/cobblemon/timcore/influence/PreventSpawnsInfluence$Companion$CacheResult;", "", "", "value", "<init>", "(Ljava/lang/String;IZ)V", "Z", "getValue", "()Z", "YES", "NO", "COMPUTING", "common"})
        public static final class CacheResult
        extends Enum<CacheResult> {
            private final boolean value;
            public static final /* enum */ CacheResult YES = new CacheResult(true);
            public static final /* enum */ CacheResult NO = new CacheResult(false);
            public static final /* enum */ CacheResult COMPUTING = new CacheResult(false);
            private static final /* synthetic */ CacheResult[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private CacheResult(boolean value) {
                this.value = value;
            }

            public final boolean getValue() {
                return this.value;
            }

            public static CacheResult[] values() {
                return (CacheResult[])$VALUES.clone();
            }

            public static CacheResult valueOf(String value) {
                return Enum.valueOf(CacheResult.class, value);
            }

            @NotNull
            public static EnumEntries<CacheResult> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = cacheResultArray = new CacheResult[]{CacheResult.YES, CacheResult.NO, CacheResult.COMPUTING};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

