/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.CursorType;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.render.RenderUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"textures/gui/background.png");
    private static final GuiGraphics GUI_GRAPHICS = new GuiGraphics(ClientUtils.getMinecraft(), null);
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
        fontRenderer.drawInBatch(text, x, y, color, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.endBatch();
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawString(poseStack, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
        fontRenderer.drawInBatch(text, x, y, color, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.endBatch();
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, text, x - (float)fontRenderer.width((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, text, x - (float)fontRenderer.width((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
        fontRenderer.drawInBatch(text, x, y, color, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.endBatch();
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
        fontRenderer.drawInBatch(text, x, y, color, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.endBatch();
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x - (float)fontRenderer.width(text) / 2.0f, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, fontRenderer, text, x - (float)fontRenderer.width(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x - (float)fontRenderer.width(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(PoseStack poseStack, float x, float y, float width, float height) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ScreenUtils.bindTexture(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(PoseStack poseStack, float x, float y, float width, float height, float yOffset) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ScreenUtils.bindTexture(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height) {
        ScreenUtils.drawTexture(poseStack, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, x, y + height, 0.0f).setUv(tx, ty + theight);
        buffer.addVertex(matrix, x + width, y + height, 0.0f).setUv(tx + twidth, ty + theight);
        buffer.addVertex(matrix, x + width, y, 0.0f).setUv(tx + twidth, ty);
        buffer.addVertex(matrix, x, y, 0.0f).setUv(tx, ty);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(poseStack, x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrix, x, y + height, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x + width, y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x, y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltipInternal(poseStack, fontRenderer, text.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList()), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, Collections.singletonList(text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, (Component)Component.literal((String)text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    private static void drawTooltipInternal(PoseStack poseStack, Font fontRenderer, List<ClientTooltipComponent> components, int x, int y) {
        if (components.isEmpty()) {
            return;
        }
        ScreenUtils.GUI_GRAPHICS.minecraft = ClientUtils.getMinecraft();
        ScreenUtils.GUI_GRAPHICS.pose = poseStack;
        ScreenUtils.GUI_GRAPHICS.bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
        GUI_GRAPHICS.renderTooltipInternal(fontRenderer, components, x, y, DefaultTooltipPositioner.INSTANCE);
        ScreenUtils.GUI_GRAPHICS.bufferSource.endBatch();
    }

    public static void drawItem(PoseStack poseStack, ItemStack stack, @Nullable Level level, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate((float)(x + 8), (float)(y + 8), 150.0f);
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale(16.0f, 16.0f, 16.0f);
        try {
            boolean useFlatLighting;
            BakedModel model = ClientUtils.getItemRenderer().getModel(stack, level, null, 0);
            boolean bl = useFlatLighting = !model.usesBlockLight();
            if (useFlatLighting) {
                Lighting.setupForFlatItems();
            }
            RenderSystem.disableDepthTest();
            MultiBufferSource.BufferSource bufferSource = ClientUtils.getMinecraft().gameRenderer.renderBuffers.bufferSource();
            ClientUtils.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            bufferSource.endBatch();
            RenderSystem.enableDepthTest();
            if (useFlatLighting) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Item being rendered");
            crashReportCategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            crashReportCategory.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
            crashReportCategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
            throw new ReportedException(crashReport);
        }
        poseStack.popPose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withScissor(PoseStack poseStack, int x, int y, int width, int height, Runnable rendering) {
        RenderUtils.getMainBufferSource().endBatch();
        Vector3f scissorStart = poseStack.last().pose().transformPosition((float)x, (float)y, 0.0f, new Vector3f());
        Vector3f scissorEnd = poseStack.last().pose().transformPosition((float)(x + width), (float)(y + height), 0.0f, new Vector3f());
        Window window = Minecraft.getInstance().getWindow();
        double guiScale = window.getGuiScale();
        double scissorX = (double)scissorStart.x * guiScale;
        double scissorY = (double)window.getHeight() - (double)scissorEnd.y * guiScale;
        double scissorWidth = (double)(scissorEnd.x - scissorStart.x) * guiScale;
        double scissorHeight = (double)(scissorEnd.y - scissorStart.y) * guiScale;
        RenderSystem.enableScissor((int)((int)scissorX), (int)((int)scissorY), (int)Math.max(0, (int)scissorWidth), (int)Math.max(0, (int)scissorHeight));
        try {
            rendering.run();
            RenderUtils.getMainBufferSource().endBatch();
        }
        finally {
            RenderSystem.disableScissor();
        }
    }

    public static void requestCursor(CursorType cursorType) {
        CursorTypes.pendingCursor = cursorType;
    }
}

