/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.client.render;

import com.hollingsworth.ars_creo.client.render.TrainHatMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.hats.EntityHats;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.RenderUtil;

public class GeoTrainHatRenderer {
    public static void render(PoseStack poseStack, LivingEntity animatable, GeoBone bone, MultiBufferSource bufferSource, int packedLight) {
        TrainHatMap.TrainData data = TrainHatMap.get(animatable.getType());
        if (data == null) {
            return;
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = animatable;
            if (bone.getName().equals(data.bone())) {
                GeoTrainHatRenderer.render(data.hatScale(), data.hatTranslation(), poseStack, livingEntity, bone, bufferSource, packedLight);
            }
        }
    }

    public static void render(Vector3f hatScale, Vector3f hatTranslation, PoseStack poseStack, LivingEntity animatable, GeoBone bone, MultiBufferSource bufferSource, int packedLight) {
        PartialModel hat = EntityHats.getHatFor((LivingEntity)animatable);
        if (hat == null) {
            return;
        }
        poseStack.pushPose();
        PoseTransformStack msr = TransformStack.of((PoseStack)poseStack);
        float scale = animatable.getScale();
        poseStack.scale(scale, scale, scale);
        RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        poseStack.scale(-hatScale.x, hatScale.y, -hatScale.z);
        poseStack.translate(hatTranslation.x, hatTranslation.y, hatTranslation.z);
        msr.rotateXDegrees(-8.5f);
        BlockState air = Blocks.AIR.defaultBlockState();
        CachedBuffers.partial((PartialModel)hat, (BlockState)air).disableDiffuse().light(packedLight).renderInto(poseStack, bufferSource.getBuffer(Sheets.cutoutBlockSheet()));
        poseStack.popPose();
    }
}

