/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.module.particle.trail;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityTrailRegistry {
    public static final Map<EntityType<? extends Entity>, Function<? extends Entity, ? extends EntityTrailProvider<? extends Entity>>> classProviders = new HashMap<EntityType<? extends Entity>, Function<? extends Entity, ? extends EntityTrailProvider<? extends Entity>>>();

    public static <T extends Entity> void registerProvider(EntityType<T> type, Function<T, EntityTrailProvider<T>> factory) {
        classProviders.put(type, factory);
    }

    public static <T extends Entity> EntityTrailProvider<T> getTrailProvider(T entity) {
        Function<? extends Entity, ? extends EntityTrailProvider<? extends Entity>> factory = classProviders.get(entity.getType());
        if (factory == null) {
            return null;
        }
        return factory.apply(entity);
    }
}

