/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.entity.PollenSifterBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class PollenSifterContainer
extends AbstractContainer<PollenSifterBlockEntity> {
    public PollenSifterContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, PollenSifterContainer.getTileEntity(playerInventory, data));
    }

    public PollenSifterContainer(int windowId, Inventory playerInventory, final PollenSifterBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.POLLEN_SIFTER_MENU.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.progress;
            }

            public void set(int value) {
                blockEntity.progress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((PollenSifterBlockEntity)this.getBlockEntity()).getItemHandler(), PollenSifterBlockEntity.SLOT_IN, 44, 34));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((PollenSifterBlockEntity)this.getBlockEntity()).getItemHandler(), PollenSifterBlockEntity.SLOT_OUT, 109, 34));
        this.addSlotBox((IItemHandler)((PollenSifterBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static PollenSifterBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof PollenSifterBlockEntity) {
            return (PollenSifterBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

