/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.emi;

import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivetrees.integrations.emi.FruitingEmiRecipe;
import cy.jdkdigital.productivetrees.integrations.emi.PollinationEmiRecipe;
import cy.jdkdigital.productivetrees.integrations.emi.SawmillEmiRecipe;
import cy.jdkdigital.productivetrees.integrations.emi.StripperEmiRecipe;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreeFruitingRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;

@EmiEntrypoint
public class ProductiveTreesEmiPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory POLLINATION_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"pollination"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.POLLEN.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"textures/gui/emi/icon/pollination.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory STRIPPING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"stripping"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.STRIPPER.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"textures/gui/emi/icon/stripping.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory SAWMILL_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.SAWMILL.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"textures/gui/emi/icon/sawmill.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory FRUITING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"fruiting"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"haw")))), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"textures/gui/emi/icon/fruiting.png"), 0, 0, 16, 16, 16, 16, 16, 16));

    public void register(EmiRegistry registry) {
        registry.addCategory(POLLINATION_CATEGORY);
        registry.addCategory(STRIPPING_CATEGORY);
        registry.addCategory(SAWMILL_CATEGORY);
        registry.addCategory(FRUITING_CATEGORY);
        RecipeManager recipeManager = registry.getRecipeManager();
        if (ModList.get().isLoaded("productivebees")) {
            registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.POLLEN_SIFTER.get())));
        } else if (!ModList.get().isLoaded("productivefarming")) {
            registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)LibItems.UPGRADE_POLLEN_SIEVE.get())));
        }
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.WOOD_WORKER.get())));
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.ENTITY_SPAWNER.get())));
        registry.addWorkstation(STRIPPING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.STRIPPER.get())));
        registry.addWorkstation(SAWMILL_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)TreeRegistrator.SAWMILL.get())));
        List pollinationRecipeList = recipeManager.getAllRecipesFor((RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get());
        pollinationRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new PollinationEmiRecipe((RecipeHolder<TreePollinationRecipe>)recipeHolder)));
        ArrayList fruitingRecipeList = new ArrayList();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (treeObject.hasFruit()) {
                fruitingRecipeList.add(new RecipeHolder(id.withPath(p -> "/" + p + "_fruiting"), (Recipe)new TreeFruitingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{TreeUtil.getBlock(id, "_sapling")}), treeObject.getFruit().getItem().copy())));
            }
        });
        fruitingRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new FruitingEmiRecipe((RecipeHolder<TreeFruitingRecipe>)recipeHolder)));
        List jsonRecipes = recipeManager.getAllRecipesFor((RecipeType)TreeRegistrator.LOG_STRIPPING_TYPE.get());
        ArrayList stripList = new ArrayList(jsonRecipes);
        Arrays.stream(Ingredient.of((TagKey)ItemTags.LOGS).getItems()).forEach(itemStack -> {
            ItemStack stripped = TreeUtil.getStrippedItem(itemStack);
            if (!stripped.isEmpty() && !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)stripped)) {
                BlockItem blockItem;
                TreeObject tree;
                ItemStack secondary = ItemStack.EMPTY;
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                Item patt0$temp = itemStack.getItem();
                if (patt0$temp instanceof BlockItem && (tree = TreeUtil.getTree((blockItem = (BlockItem)patt0$temp).getBlock())) != null && tree.getStripDrop().isPresent()) {
                    secondary = tree.getStripDropStack();
                }
                stripList.add(new RecipeHolder(id.withPath(p -> "/" + p + "_sawmill"), (Recipe)new LogStrippingRecipe((ItemStack)itemStack, stripped, secondary)));
            }
        });
        stripList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new StripperEmiRecipe((RecipeHolder<LogStrippingRecipe>)recipeHolder)));
        List sawmillRecipeList = recipeManager.getAllRecipesFor((RecipeType)TreeRegistrator.SAW_MILLLING_TYPE.get());
        sawmillRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new SawmillEmiRecipe((RecipeHolder<SawmillRecipe>)recipeHolder)));
        for (String name : List.of("black_ember", "blue_yonder", "firecracker", "flickering_sun", "soul_tree", "brown_amber")) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)TreeUtil.getBlock(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)name), "_sapling"))), List.of(Component.translatable((String)("productivetrees.sapling_description." + name))), null));
        }
    }
}

