/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import cy.jdkdigital.productivetrees.util.WoodSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class ModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public ModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            ProductiveTrees.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        TreeFinder.trees.forEach((id, treeObject) -> {
            this.addBlockItemModel(TreeUtil.getBlock(id, "_leaves"), "leaves/" + treeObject.getStyle().leafStyle(), itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_planks"), "planks/" + treeObject.getStyle().plankStyle(), itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_log"), "log/" + treeObject.getStyle().woodStyle() + "_log", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_stripped_log"), "log/" + treeObject.getStyle().woodStyle() + "_stripped_log", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_wood"), "log/" + treeObject.getStyle().woodStyle() + "_wood", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_stripped_wood"), "log/" + treeObject.getStyle().woodStyle() + "_stripped_wood", itemModels);
            if (!ProductiveTrees.isMinimal) {
                this.addBlockItemModel(TreeUtil.getBlock(id, "_slab"), "slab/" + treeObject.getStyle().plankStyle() + "_slab", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_stairs"), "stairs/" + treeObject.getStyle().plankStyle() + "_stairs", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_button"), "button/" + treeObject.getStyle().plankStyle() + "_button_inventory", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_pressure_plate"), "pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_fence"), "fence/" + treeObject.getStyle().plankStyle() + "_fence_inventory", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_fence_gate"), "fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate", itemModels);
                ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)TreeUtil.getBlock(id, "_door").asItem()), new TextureMapping().put(TextureSlot.LAYER0, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("item/door/" + treeObject.getStyle().doorStyle()))), modelOutput);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_trapdoor"), "trapdoor/" + treeObject.getStyle().doorStyle() + "_bottom", itemModels);
                this.addBlockItemModel(TreeUtil.getBlock(id, "_bookshelf"), "bookshelf/" + treeObject.getStyle().plankStyle(), itemModels);
                this.generateFlatItem(TreeUtil.getBlock(id, "_sign").asItem(), "item/sign/", modelOutput);
                this.generateFlatItem(TreeUtil.getBlock(id, "_hanging_sign").asItem(), "item/hanging_sign/", modelOutput);
            }
        });
        this.generateFruitItem((Item)TreeRegistrator.COFFEE_BEAN.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CAROB.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.ALLSPICE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CLOVE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CINNAMON.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.NUTMEG.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.STAR_ANISE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.PLANET_PEACH.get(), modelOutput);
        this.generateMultiItem((Item)TreeRegistrator.FUSTIC.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.CORK.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.HAEMATOXYLIN.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.DRACAENA_SAP.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.RUBBER.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.CURED_RUBBER.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.MAPLE_SAP_BUCKET.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.MAPLE_SYRUP.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.DATE_PALM_JUICE.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.SANDALWOOD_OIL.get(), "item/", modelOutput);
        TreeRegistrator.BERRIES.forEach(cropConfig -> this.generateFruitItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name())), modelOutput));
        TreeRegistrator.FRUITS.forEach(cropConfig -> this.generateFruitItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name())), modelOutput));
        TreeRegistrator.NUTS.forEach(cropConfig -> this.generateFruitItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name())), modelOutput));
        TreeRegistrator.ROASTED_NUTS.forEach(cropConfig -> this.generateFruitItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name())), modelOutput));
        TreeRegistrator.CRATED_CROPS.forEach(crate -> this.addBlockItemParentModel((Block)BuiltInRegistries.BLOCK.get(crate), "crates/", itemModels));
        this.addBlockItemParentModel((Block)TreeRegistrator.SAWMILL.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.STRIPPER.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.POLLEN_SIFTER.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.WOOD_WORKER.get(), "", itemModels);
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private void generateFruitItem(Item item, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        this.generateFlatItem(item, "item/fruit/", modelOutput);
    }

    private void generateMultiItem(Item item, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        this.generateMultiItem(item, "item/fruit/", modelOutput);
    }

    private void generateMultiItem(Item item, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ResourceLocation tLocation = BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/").withSuffix("_two");
        ModelTemplates.FLAT_ITEM.create(tLocation, ModelProvider.getFlatItemTextureMap(item, suffix, "_two"), modelOutput);
        ResourceLocation mLocation = BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/").withSuffix("_multiple");
        ModelTemplates.FLAT_ITEM.create(mLocation, ModelProvider.getFlatItemTextureMap(item, suffix, "_multiple"), modelOutput);
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, suffix), modelOutput, this::createFruitTemplate);
    }

    public JsonObject createFruitTemplate(ResourceLocation resourceLocation, Map<TextureSlot, ResourceLocation> slotResourceLocationMap) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", "minecraft:item/generated");
        if (!slotResourceLocationMap.isEmpty()) {
            JsonObject textureLocations = new JsonObject();
            slotResourceLocationMap.forEach((textureSlot, resourceLocation1) -> textureLocations.addProperty(textureSlot.getId(), resourceLocation1.toString()));
            jsonobject.add("textures", (JsonElement)textureLocations);
        }
        JsonArray overrides = new JsonArray();
        JsonObject twoOverride = new JsonObject();
        JsonObject twoPredicate = new JsonObject();
        twoPredicate.addProperty("count", (Number)2);
        twoOverride.add("predicate", (JsonElement)twoPredicate);
        twoOverride.addProperty("model", resourceLocation.toString() + "_two");
        JsonObject moreOverride = new JsonObject();
        JsonObject morePredicate = new JsonObject();
        morePredicate.addProperty("count", (Number)3);
        moreOverride.add("predicate", (JsonElement)morePredicate);
        moreOverride.addProperty("model", String.valueOf(resourceLocation) + "_multiple");
        overrides.add((JsonElement)twoOverride);
        overrides.add((JsonElement)moreOverride);
        jsonobject.add("overrides", (JsonElement)overrides);
        return jsonobject;
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return ModelProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        ResourceLocation resourcelocation = BuiltInRegistries.ITEM.getKey((Object)item);
        return new TextureMapping().put(TextureSlot.LAYER0, resourcelocation.withPrefix(prefix).withSuffix(suffix));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemModel(Block block, String base, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/" + base))), itemModels);
        }
    }

    private void addBlockItemParentModel(Block block, String prefix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("block/" + prefix + rl.getPath()))), itemModels);
        }
    }

    public String getName() {
        return "Productive Trees Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
        static ModelTemplate crateModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"block/base_crate")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.CROP});

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            TreeFinder.trees.forEach((id, treeObject) -> {
                this.createSapling((TreeObject)treeObject);
                this.createBaseBlock(TreeUtil.getBlock(id, "_leaves"), "leaves/" + treeObject.getStyle().leafStyle());
                if (treeObject.hasFruit()) {
                    this.createFruitBlock((TreeObject)treeObject);
                }
                if (treeObject.getId().getPath().equals("cinnamon")) {
                    this.createCrate((TreeObject)treeObject, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"cinnamon"));
                }
                new WoodProvider().logWithHorizontal(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_log"), false).wood(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_wood"), false);
                new WoodProvider().logWithHorizontal(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_stripped_log"), true).wood(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_stripped_wood"), true);
                this.createBaseBlock(TreeUtil.getBlock(id, "_planks"), "planks/" + treeObject.getStyle().plankStyle());
                if (!ProductiveTrees.isMinimal) {
                    this.createStairsBlock((WoodObject)treeObject);
                    this.createSlabBlock((WoodObject)treeObject);
                    this.createPressurePlateBlock((WoodObject)treeObject);
                    this.createButtonBlock((WoodObject)treeObject);
                    this.createFenceGateBlock((WoodObject)treeObject);
                    this.createFenceBlock((WoodObject)treeObject);
                    this.createDoorBlock((WoodObject)treeObject);
                    this.createTrapdoorBlock((WoodObject)treeObject);
                    this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_bookshelf"), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/bookshelf/" + treeObject.getStyle().plankStyle()))));
                    this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_sign"), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/" + treeObject.getStyle().plankStyle()))));
                    this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_wall_sign"), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/" + treeObject.getStyle().plankStyle()))));
                    this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_hanging_sign"), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/hanging_" + treeObject.getStyle().plankStyle()))));
                    this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_wall_hanging_sign"), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/hanging_" + treeObject.getStyle().plankStyle()))));
                }
            });
            this.createBaseModels();
        }

        private void createSapling(TreeObject treeObject) {
            Item item;
            Block block = TreeUtil.getBlock(treeObject.getId(), "_sapling");
            Block pottedBlock = TreeUtil.getBlock(treeObject.getId(), "_potted_sapling");
            String baseSapling = "";
            if (treeObject.hasFruit()) {
                baseSapling = "fruiting_";
            }
            if ((item = block.asItem()) != Items.AIR) {
                this.modelOutput.accept(ModelLocationUtils.getModelLocation((Item)item), (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("item/sapling/base_" + baseSapling + treeObject.getStyle().saplingStyle()))));
            }
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(pottedBlock, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sapling/base_potted_sapling_" + treeObject.getStyle().saplingStyle()))));
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(block, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sapling/base_" + baseSapling + treeObject.getStyle().saplingStyle()))));
        }

        private void createCrate(TreeObject treeObject, Block block) {
            if (treeObject.getStyle().crateStyle() == null) {
                throw new RuntimeException(String.valueOf(treeObject.getId()) + " is missing a crate style");
            }
            ResourceLocation top = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/crate/" + p.replace("_crate", ""));
            TextureMapping textureMapping = new TextureMapping().put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/crate/" + treeObject.getStyle().crateStyle() + "/side"))).put(TextureSlot.TOP, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/crate/" + treeObject.getStyle().crateStyle() + "/top"))).put(TextureSlot.BOTTOM, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/crate/" + treeObject.getStyle().crateStyle() + "/bottom"))).put(TextureSlot.CROP, top);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)crateModel.create(BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/crates/" + p), textureMapping, this.modelOutput))));
        }

        static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation));
        }

        static BlockStateGenerator createAxisAlignedPillarBlock(Block block, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation)).with(ModelGenerator.createRotatedPillar());
        }

        static BlockStateGenerator createRotatedPillarWithHorizontalVariant(Block p_124925_, ResourceLocation p_124926_, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.multiVariant((Block)p_124925_).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.Y, Variant.variant().with(VariantProperties.MODEL, (Object)p_124926_)).select((Comparable)Direction.Axis.Z, Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.Axis.X, Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)));
        }

        private static PropertyDispatch createRotatedPillar() {
            return PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.Y, Variant.variant()).select((Comparable)Direction.Axis.Z, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.Axis.X, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
        }

        private void createBaseBlock(Block block, String baseName) {
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(block, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/" + baseName))));
        }

        private void createFruitBlock(TreeObject treeObject) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)TreeUtil.getBlock(treeObject.getId(), "_fruit")).with(PropertyDispatch.property((Property)ProductiveFruitBlock.getAgeProperty()).generate(age -> {
                String fruitStyle = treeObject.getFruit().style();
                if (fruitStyle.equals("default")) {
                    ModelTemplate template = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"block/fruit/base_fruit")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL, TextureSlot.PLANT});
                    return Variant.variant().with(VariantProperties.MODEL, (Object)template.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fruit/" + treeObject.getId().getPath() + "/stage_" + age)), new TextureMapping().put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/leaves/" + treeObject.getStyle().leafStyle()))).put(TextureSlot.PLANT, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fruit/" + treeObject.getId().getPath() + "/stage_" + age))), this.modelOutput));
                }
                ModelTemplate template = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fruit/" + fruitStyle + "/fruit_" + age))), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
                return Variant.variant().with(VariantProperties.MODEL, (Object)template.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fruit/" + treeObject.getId().getPath() + "/" + age)), new TextureMapping().put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/leaves/" + treeObject.getStyle().leafStyle()))), this.modelOutput));
            })));
            this.createCrate(treeObject, treeObject.getFruit().fruitItem());
        }

        private void createCrate(TreeObject treeObject, ResourceLocation item) {
            ResourceLocation roastedCratePath;
            ResourceLocation cratePath = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)item.withPath(p -> p.equals("apple") ? "red_delicious_apple_crate" : p + "_crate").getPath());
            if (TreeRegistrator.CRATED_CROPS.contains(cratePath) && !treeObject.getId().getPath().contains("copper_beech") && !treeObject.getId().getPath().contains("purple_blackthorn")) {
                this.createCrate(treeObject, (Block)BuiltInRegistries.BLOCK.get(cratePath));
            }
            if (TreeRegistrator.CRATED_CROPS.contains(roastedCratePath = item.withPath(p -> "roasted_" + p + "_crate")) && !treeObject.getId().getPath().contains("copper_beech") && !treeObject.getId().getPath().contains("purple_blackthorn")) {
                this.createCrate(treeObject, (Block)BuiltInRegistries.BLOCK.get(roastedCratePath));
            }
        }

        private void createStairsBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_stairs");
            ResourceLocation stairs = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs"));
            ResourceLocation stairsInner = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs_inner"));
            ResourceLocation stairsOuter = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs_outer"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)HorizontalDirectionalBlock.FACING, (Property)BlockStateProperties.HALF, (Property)BlockStateProperties.STAIRS_SHAPE).generate((facing, half, shape) -> {
                int yRotValue = (int)facing.getClockWise().toYRot();
                if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                    yRotValue += 270;
                }
                if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                    yRotValue += 90;
                }
                boolean uvLock = (yRotValue %= 360) != 0 || half == Half.TOP;
                VariantProperties.Rotation yRot = switch (yRotValue) {
                    case 90 -> VariantProperties.Rotation.R90;
                    case 180 -> VariantProperties.Rotation.R180;
                    case 270 -> VariantProperties.Rotation.R270;
                    default -> VariantProperties.Rotation.R0;
                };
                Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)));
                if (half != Half.BOTTOM) {
                    variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180);
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.with(VariantProperties.Y_ROT, (Object)yRot);
                }
                if (uvLock) {
                    variant.with(VariantProperties.UV_LOCK, (Object)true);
                }
                return variant;
            })));
        }

        private void createSlabBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_slab");
            ResourceLocation slab = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + treeObject.getStyle().plankStyle() + "_slab"));
            ResourceLocation planks = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + treeObject.getStyle().plankStyle()));
            ResourceLocation slabTop = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + treeObject.getStyle().plankStyle() + "_slab_top"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.SLAB_TYPE).generate(slabType -> Variant.variant().with(VariantProperties.MODEL, (Object)(slabType == SlabType.BOTTOM ? slab : (slabType == SlabType.TOP ? slabTop : planks))))));
        }

        private void createPressurePlateBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_pressure_plate");
            ResourceLocation plate = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate"));
            ResourceLocation plateDown = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate_down"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.POWERED).generate(powered -> Variant.variant().with(VariantProperties.MODEL, (Object)(powered != false ? plateDown : plate)))));
        }

        private void createButtonBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_button");
            ResourceLocation button = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + treeObject.getStyle().plankStyle() + "_button"));
            ResourceLocation buttonPressed = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + treeObject.getStyle().plankStyle() + "_button_pressed"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)ButtonBlock.FACING, (Property)ButtonBlock.FACE, (Property)ButtonBlock.POWERED).generate((facing, face, powered) -> {
                VariantProperties.Rotation yRot;
                Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)(powered != false ? buttonPressed : button));
                int yRotValue = (int)(face == AttachFace.CEILING ? facing : facing.getOpposite()).toYRot();
                switch (yRotValue) {
                    case 90: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R90;
                        break;
                    }
                    case 180: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R180;
                        break;
                    }
                    case 270: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R270;
                        break;
                    }
                    default: {
                        VariantProperties.Rotation rotation = yRot = VariantProperties.Rotation.R0;
                    }
                }
                if (face != AttachFace.FLOOR) {
                    variant.with(VariantProperties.X_ROT, (Object)(face == AttachFace.WALL ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R180));
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.with(VariantProperties.Y_ROT, (Object)yRot);
                }
                if (face == AttachFace.WALL) {
                    variant.with(VariantProperties.UV_LOCK, (Object)true);
                }
                return variant;
            })));
        }

        private void createFenceGateBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_fence_gate");
            ResourceLocation fenceGate = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate"));
            ResourceLocation fenceGateOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_open"));
            ResourceLocation fenceGateWall = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_wall"));
            ResourceLocation fenceGateWallOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_wall_open"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)FenceGateBlock.FACING, (Property)FenceGateBlock.IN_WALL, (Property)FenceGateBlock.OPEN).generate((facing, inWall, open) -> {
                VariantProperties.Rotation yRot;
                Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)(open.booleanValue() ? (inWall.booleanValue() ? fenceGateWallOpen : fenceGateOpen) : (inWall != false ? fenceGateWall : fenceGate)));
                int yRotValue = (int)facing.toYRot();
                switch (yRotValue) {
                    case 90: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R90;
                        break;
                    }
                    case 180: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R180;
                        break;
                    }
                    case 270: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R270;
                        break;
                    }
                    default: {
                        VariantProperties.Rotation rotation = yRot = VariantProperties.Rotation.R0;
                    }
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.with(VariantProperties.Y_ROT, (Object)yRot);
                }
                variant.with(VariantProperties.UV_LOCK, (Object)true);
                return variant;
            })));
        }

        private void createFenceBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_fence");
            ResourceLocation fencePost = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + treeObject.getStyle().plankStyle() + "_fence_post"));
            ResourceLocation fenceSide = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + treeObject.getStyle().plankStyle() + "_fence_side"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.multiPart((Block)block).with(Variant.variant().with(VariantProperties.MODEL, (Object)fencePost)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)fenceSide).with(VariantProperties.UV_LOCK, (Object)true)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)fenceSide).with(VariantProperties.UV_LOCK, (Object)true).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)fenceSide).with(VariantProperties.UV_LOCK, (Object)true).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)fenceSide).with(VariantProperties.UV_LOCK, (Object)true).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)));
        }

        private void createDoorBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_door");
            ResourceLocation bottomLeft = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_bottom_left"));
            ResourceLocation bottomLeftOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_bottom_left_open"));
            ResourceLocation bottomRight = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_bottom_right"));
            ResourceLocation bottomRightOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_bottom_right_open"));
            ResourceLocation topLeft = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_top_left"));
            ResourceLocation topLeftOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_top_left_open"));
            ResourceLocation topRight = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_top_right"));
            ResourceLocation topRightOpen = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + treeObject.getStyle().doorStyle() + "_top_right_open"));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(ModelGenerator.configureDoorHalf(ModelGenerator.configureDoorHalf((PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean>)PropertyDispatch.properties((Property)DoorBlock.FACING, (Property)DoorBlock.HALF, (Property)DoorBlock.HINGE, (Property)DoorBlock.OPEN), DoubleBlockHalf.LOWER, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen), DoubleBlockHalf.UPPER, topLeft, topLeftOpen, topRight, topRightOpen)));
        }

        private static PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> configureDoorHalf(PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> p_236305_, DoubleBlockHalf half, ResourceLocation left, ResourceLocation leftOpen, ResourceLocation right, ResourceLocation rightOpen) {
            return p_236305_.select((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)left)).select((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)right)).select((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)leftOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)rightOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)left).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)right).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)leftOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)rightOpen)).select((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)left).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)right).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)leftOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)rightOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)left).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)right).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)leftOpen)).select((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)rightOpen).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
        }

        private void createTrapdoorBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_trapdoor");
            ResourceLocation top = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + treeObject.getStyle().doorStyle() + "_top"));
            ResourceLocation bottom = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + treeObject.getStyle().doorStyle() + "_bottom"));
            ResourceLocation open = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + treeObject.getStyle().doorStyle() + "_open"));
            this.blockStateOutput.accept(ModelGenerator.createTrapdoor(block, top, bottom, open));
        }

        private static BlockStateGenerator createTrapdoor(Block block, ResourceLocation top, ResourceLocation bottom, ResourceLocation open) {
            return MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.HALF, (Property)BlockStateProperties.OPEN).select((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)bottom)).select((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)bottom).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)bottom).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)bottom).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)top)).select((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)top).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)top).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)top).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open)).select((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0)).select((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)open).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)));
        }

        private void createBaseModels() {
            WoodSet.STYLES.forEach((name, style) -> {
                String modelPrefix = TreeUtil.isTranslucentTree(name) ? "translucent_" : "";
                ModelTemplate planksModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + modelPrefix + "base_planks"))), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
                ModelTemplate buttonModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + modelPrefix + "base_button"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate buttonInventoryModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + modelPrefix + "base_button_inventory"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate buttonPressedModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + modelPrefix + "base_button_pressed"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceInventoryModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + modelPrefix + "base_fence_inventory"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fencePostModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + modelPrefix + "base_fence_post"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceSideModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + modelPrefix + "base_fence_side"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceGateModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + modelPrefix + "base_fence_gate"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceGateOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + modelPrefix + "base_fence_gate_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceGateWallModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + modelPrefix + "base_fence_gate_wall"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate fenceGateWallOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + modelPrefix + "base_fence_gate_wall_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate pressurePlateModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + modelPrefix + "base_pressure_plate"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate pressurePlateDownModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + modelPrefix + "base_pressure_plate_down"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate slabModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + modelPrefix + "base_slab"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate slabTopModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + modelPrefix + "base_slab_top"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate stairsModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + modelPrefix + "base_stairs"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate stairsInnerModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + modelPrefix + "base_stairs_inner"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate stairsOuterModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + modelPrefix + "base_stairs_outer"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate leavesModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/leaves/" + modelPrefix + "base_leaves"))), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
                ModelTemplate logModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + modelPrefix + "base_log"))), Optional.empty(), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
                ModelTemplate logHorizontalModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + modelPrefix + "base_log_horizontal"))), Optional.empty(), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
                ModelTemplate cubeColumnModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/" + modelPrefix + "cube_column"))), Optional.empty(), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
                ModelTemplate cubeColumnHorizontalModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/" + modelPrefix + "cube_column_horizontal"))), Optional.empty(), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
                ModelTemplate doorBottomLeftModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "bottom_left"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorBottomLeftOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "bottom_left_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorBottomRightModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "bottom_right"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorBottomRightOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "bottom_right_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorTopLeftModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "top_left"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorTopLeftOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "top_left_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorTopRightModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "top_right"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate doorTopRightOpenModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + modelPrefix + "top_right_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP});
                ModelTemplate trapdoorBottom = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_bottom"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate trapdoorOpen = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_open"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate trapdoorTop = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_top"))), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
                ModelTemplate bookshelf = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/" + modelPrefix + "base_bookshelf"))), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE});
                ModelTemplate sign = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/" + modelPrefix + "base_sign"))), Optional.empty(), new TextureSlot[]{TextureSlot.PARTICLE});
                ModelTemplate hangingSign = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/" + modelPrefix + "base_sign"))), Optional.empty(), new TextureSlot[]{TextureSlot.PARTICLE});
                TextureMapping plankTextureMap = new TextureMapping().put(TextureSlot.TEXTURE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + style.plankStyle()))).put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + style.plankStyle())));
                planksModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + name)), plankTextureMap, this.modelOutput);
                buttonModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + name + "_button")), plankTextureMap, this.modelOutput);
                buttonInventoryModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + name + "_button_inventory")), plankTextureMap, this.modelOutput);
                buttonPressedModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/button/" + name + "_button_pressed")), plankTextureMap, this.modelOutput);
                fenceInventoryModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + name + "_fence_inventory")), plankTextureMap, this.modelOutput);
                fencePostModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + name + "_fence_post")), plankTextureMap, this.modelOutput);
                fenceSideModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence/" + name + "_fence_side")), plankTextureMap, this.modelOutput);
                fenceGateModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + name + "_fence_gate")), plankTextureMap, this.modelOutput);
                fenceGateOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + name + "_fence_gate_open")), plankTextureMap, this.modelOutput);
                fenceGateWallModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + name + "_fence_gate_wall")), plankTextureMap, this.modelOutput);
                fenceGateWallOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/fence_gate/" + name + "_fence_gate_wall_open")), plankTextureMap, this.modelOutput);
                pressurePlateModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + name + "_pressure_plate")), plankTextureMap, this.modelOutput);
                pressurePlateDownModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/pressure_plate/" + name + "_pressure_plate_down")), plankTextureMap, this.modelOutput);
                slabModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + name + "_slab")), plankTextureMap, this.modelOutput);
                slabTopModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/slab/" + name + "_slab_top")), plankTextureMap, this.modelOutput);
                stairsModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + name + "_stairs")), plankTextureMap, this.modelOutput);
                stairsInnerModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + name + "_stairs_inner")), plankTextureMap, this.modelOutput);
                stairsOuterModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stairs/" + name + "_stairs_outer")), plankTextureMap, this.modelOutput);
                TextureMapping leavesTextureMap = new TextureMapping().put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/leaves/" + style.leafStyle())));
                leavesModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/leaves/" + name)), leavesTextureMap, this.modelOutput);
                TextureMapping logTextureMap = new TextureMapping().put(TextureSlot.END, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log_top/" + style.woodStyle()))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + style.woodStyle())));
                logModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_log")), logTextureMap, this.modelOutput);
                logHorizontalModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_log_horizontal")), logTextureMap, this.modelOutput);
                TextureMapping strippedLogTextureMap = new TextureMapping().put(TextureSlot.END, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stripped/" + style.woodStyle() + "_top"))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stripped/" + style.woodStyle())));
                cubeColumnModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_stripped_log")), strippedLogTextureMap, this.modelOutput);
                cubeColumnHorizontalModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_stripped_log_horizontal")), strippedLogTextureMap, this.modelOutput);
                TextureMapping strippedWoodTextureMap = new TextureMapping().put(TextureSlot.END, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stripped/" + style.woodStyle()))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stripped/" + style.woodStyle())));
                cubeColumnModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_stripped_wood")), strippedWoodTextureMap, this.modelOutput);
                TextureMapping woodTextureMap = new TextureMapping().put(TextureSlot.END, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + style.woodStyle()))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + style.woodStyle())));
                cubeColumnModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/log/" + name + "_wood")), woodTextureMap, this.modelOutput);
                TextureMapping doorTextureMap = new TextureMapping().put(TextureSlot.TOP, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + style.doorStyle() + "_top"))).put(TextureSlot.BOTTOM, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + style.doorStyle() + "_bottom")));
                doorBottomLeftModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_bottom_left")), doorTextureMap, this.modelOutput);
                doorBottomLeftOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_bottom_left_open")), doorTextureMap, this.modelOutput);
                doorBottomRightModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_bottom_right")), doorTextureMap, this.modelOutput);
                doorBottomRightOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_bottom_right_open")), doorTextureMap, this.modelOutput);
                doorTopLeftModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_top_left")), doorTextureMap, this.modelOutput);
                doorTopLeftOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_top_left_open")), doorTextureMap, this.modelOutput);
                doorTopRightModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_top_right")), doorTextureMap, this.modelOutput);
                doorTopRightOpenModel.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/door/" + name + "_top_right_open")), doorTextureMap, this.modelOutput);
                TextureMapping trapdoorTextureMap = new TextureMapping().put(TextureSlot.TEXTURE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + style.doorStyle())));
                trapdoorBottom.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + name + "_bottom")), trapdoorTextureMap, this.modelOutput);
                trapdoorOpen.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + name + "_open")), trapdoorTextureMap, this.modelOutput);
                trapdoorTop.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/trapdoor/" + name + "_top")), trapdoorTextureMap, this.modelOutput);
                TextureMapping bookshelfTextureMap = new TextureMapping().put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + style.plankStyle())));
                bookshelf.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/bookshelf/" + name)), bookshelfTextureMap, this.modelOutput);
                TextureMapping signTextureMap = new TextureMapping().put(TextureSlot.TEXTURE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/planks/" + style.plankStyle())));
                TextureMapping hangingSignTextureMap = new TextureMapping().put(TextureSlot.TEXTURE, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/stripped/" + style.plankStyle())));
                sign.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/" + name)), signTextureMap, this.modelOutput);
                hangingSign.create(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("block/sign/hanging_" + name)), hangingSignTextureMap, this.modelOutput);
            });
        }

        class WoodProvider {
            public WoodProvider wood(String style, Block block, boolean stripped) {
                ModelGenerator.this.blockStateOutput.accept(ModelGenerator.createAxisAlignedPillarBlock(block, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(stripped ? "block/log/" + style + "_stripped_wood" : "block/log/" + style + "_wood"))));
                return this;
            }

            public WoodProvider logWithHorizontal(String style, Block block, boolean stripped) {
                return this.logWithHorizontal(style, block, stripped, "log");
            }

            public WoodProvider logWithHorizontal(String style, Block block, boolean stripped, String type) {
                ResourceLocation rLoc = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(stripped ? "block/log/" + style + "_stripped_" + type : "block/log/" + style + "_" + type));
                ResourceLocation rLocHor = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(stripped ? "block/log/" + style + "_stripped_" + type + "_horizontal" : "block/log/" + style + "_" + type + "_horizontal"));
                ModelGenerator.this.blockStateOutput.accept(ModelGenerator.createRotatedPillarWithHorizontalVariant(block, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)rLoc.getPath()), ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)rLocHor.getPath())));
                return this;
            }
        }
    }
}

