/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagProvider
extends BlockTagsProvider {
    public BlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        super(output, provider, "productivetrees", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender axeMineable = this.tag(BlockTags.MINEABLE_WITH_AXE);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pickaxeMineable = this.tag(BlockTags.MINEABLE_WITH_PICKAXE);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender storageBlocks = this.tag(Tags.Blocks.STORAGE_BLOCKS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender dof = this.tag(ModTags.DIRT_OR_FARMLAND);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pollinatable = this.tag(ModTags.POLLINATABLE);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender flowers = this.tag(BlockTags.FLOWERS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender planks = this.tag(BlockTags.PLANKS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender logs = this.tag(BlockTags.LOGS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender logsThatBurn = this.tag(BlockTags.LOGS_THAT_BURN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender sapling = this.tag(BlockTags.SAPLINGS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender leaves = this.tag(BlockTags.LEAVES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender slabs = this.tag(BlockTags.WOODEN_SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pressurePlates = this.tag(BlockTags.WOODEN_PRESSURE_PLATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender stairs = this.tag(BlockTags.WOODEN_STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fences = this.tag(BlockTags.WOODEN_FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fenceGates = this.tag(BlockTags.FENCE_GATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenFenceGates = this.tag(Tags.Blocks.FENCE_GATES_WOODEN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender buttons = this.tag(BlockTags.WOODEN_BUTTONS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender doors = this.tag(BlockTags.WOODEN_DOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender trapdoors = this.tag(BlockTags.WOODEN_TRAPDOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender bookshelves = this.tag(Tags.Blocks.BOOKSHELVES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender enchantment = this.tag(BlockTags.ENCHANTMENT_POWER_PROVIDER);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender signs = this.tag(BlockTags.STANDING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender hangingSigns = this.tag(BlockTags.CEILING_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender wallHangingSigns = this.tag(BlockTags.WALL_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender wallSigns = this.tag(BlockTags.WALL_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender hives = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:advanced_beehives")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender boxes = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:expansion_boxes")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender spring_crops = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"sereneseasons:spring_crops")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender summer_crops = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"sereneseasons:summer_crops")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender autumn_crops = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"sereneseasons:autumn_crops")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender winter_crops = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"sereneseasons:winter_crops")));
        TreeFinder.trees.forEach((id, treeObject) -> {
            sapling.add((Object)TreeUtil.getBlock(id, "_sapling"));
            spring_crops.add((Object)TreeUtil.getBlock(id, "_sapling"));
            summer_crops.add((Object)TreeUtil.getBlock(id, "_sapling"));
            autumn_crops.add((Object)TreeUtil.getBlock(id, "_sapling"));
            winter_crops.add((Object)TreeUtil.getBlock(id, "_sapling"));
            leaves.add((Object)TreeUtil.getBlock(id, "_leaves"));
            if (treeObject.hasFruit()) {
                leaves.add((Object)TreeUtil.getBlock(id, "_fruit"));
                spring_crops.add((Object)TreeUtil.getBlock(id, "_fruit"));
                summer_crops.add((Object)TreeUtil.getBlock(id, "_fruit"));
                autumn_crops.add((Object)TreeUtil.getBlock(id, "_fruit"));
            }
            if (id.getPath().equals("purple_spiral")) {
                flowers.add((Object)TreeUtil.getBlock(id, "_leaves"));
            }
            axeMineable.add((Object)TreeUtil.getBlock(id, "_bookshelf"));
            planks.add((Object)TreeUtil.getBlock(id, "_planks"));
            TagKey logTag = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(id.getPath() + "_logs")));
            this.tag(logTag).add((Object[])new Block[]{TreeUtil.getBlock(id, "_log"), TreeUtil.getBlock(id, "_wood"), TreeUtil.getBlock(id, "_stripped_log"), TreeUtil.getBlock(id, "_stripped_wood")});
            if (treeObject.isFireProof()) {
                logs.addTag(logTag);
            } else {
                logsThatBurn.addTag(logTag);
            }
            if (!ProductiveTrees.isMinimal) {
                stairs.add((Object)TreeUtil.getBlock(id, "_stairs"));
                slabs.add((Object)TreeUtil.getBlock(id, "_slab"));
                fences.add((Object)TreeUtil.getBlock(id, "_fence"));
                fenceGates.add((Object)TreeUtil.getBlock(id, "_fence_gate"));
                woodenFenceGates.add((Object)TreeUtil.getBlock(id, "_fence_gate"));
                pressurePlates.add((Object)TreeUtil.getBlock(id, "_pressure_plate"));
                buttons.add((Object)TreeUtil.getBlock(id, "_button"));
                doors.add((Object)TreeUtil.getBlock(id, "_door"));
                trapdoors.add((Object)TreeUtil.getBlock(id, "_trapdoor"));
                signs.add((Object)TreeUtil.getBlock(id, "_sign"));
                bookshelves.add((Object)TreeUtil.getBlock(id, "_bookshelf"));
                enchantment.add((Object)TreeUtil.getBlock(id, "_bookshelf"));
                hangingSigns.add((Object)TreeUtil.getBlock(id, "_hanging_sign"));
                wallSigns.add((Object)TreeUtil.getBlock(id, "_wall_sign"));
                wallHangingSigns.add((Object)TreeUtil.getBlock(id, "_wall_hanging_sign"));
            }
            if (treeObject.getStyle().hiveStyle() != null) {
                hives.addOptional(Objects.requireNonNull(treeObject.getId().withPath(p -> "advanced_" + p + "_beehive")));
                boxes.addOptional(Objects.requireNonNull(treeObject.getId().withPath(p -> "expansion_box_" + p)));
            }
        });
        leaves.add((Object)((Block)TreeRegistrator.POLLINATED_LEAVES.get()));
        dof.addOptionalTag(BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"dirt")));
        dof.add((Object)Blocks.FARMLAND);
        pollinatable.addTag(BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"leaves"))).add((Object[])new Block[]{Blocks.WARPED_WART_BLOCK, Blocks.NETHER_WART_BLOCK});
        TreeRegistrator.CRATED_CROPS.forEach(cratePath -> {
            Block crateBlock = (Block)BuiltInRegistries.BLOCK.get(cratePath);
            TagKey blockTagKey = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + cratePath.getPath().replace("_crate", ""))));
            this.tag(blockTagKey).add((Object)crateBlock);
            storageBlocks.addTag(blockTagKey);
            axeMineable.addTag(blockTagKey);
        });
        axeMineable.add((Object)((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get()));
        pickaxeMineable.add((Object)((Block)TreeRegistrator.STRIPPER.get()));
        pickaxeMineable.add((Object)((Block)TreeRegistrator.SAWMILL.get()));
        pickaxeMineable.add((Object)((Block)TreeRegistrator.WOOD_WORKER.get()));
        pickaxeMineable.add((Object)((Block)TreeRegistrator.POLLEN_SIFTER.get()));
    }

    public String getName() {
        return "Productive Trees Block Tags Provider";
    }
}

