/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IUpgradeableBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivetrees.inventory.SawmillContainer;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SawmillBlockEntity
extends CapabilityBlockEntity
implements MenuProvider,
IUpgradeableBlockEntity {
    protected int tickCounter = 0;
    public int tickRate = 10;
    public int recipeTime = 200;
    public int progress = 0;
    private ItemStack buffer = ItemStack.EMPTY;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_SECONDARY = 2;
    public static int SLOT_TERTIARY = 3;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(4, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            return slot != SLOT_IN && !SawmillBlockEntity.this.canProcess(stack);
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            if (slot == SLOT_IN && SawmillBlockEntity.this.canProcess(stack)) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                return currentOutStack.isEmpty() || currentOutStack.getCount() < currentOutStack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentOutStack);
            }
            return false;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_IN;
        }

        public boolean isInsertableSlot(int slot) {
            return slot == SLOT_IN;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT, SLOT_SECONDARY, SLOT_TERTIARY};
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get()));

    public SawmillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.SAWMILL_BLOCK_ENTITY.get(), pos, state);
    }

    public Component getName() {
        return Component.translatable((String)((Block)TreeRegistrator.SAWMILL.get()).getDescriptionId());
    }

    private boolean canProcess(ItemStack stack) {
        return TreeUtil.getSawmillRecipe(this.level, stack) != null;
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SawmillBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % blockEntity.tickRate == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack log = blockEntity.inventoryHandler.getStackInSlot(SLOT_IN);
            ItemStack output = blockEntity.inventoryHandler.getStackInSlot(SLOT_OUT);
            if (!blockEntity.buffer.isEmpty() && blockEntity.inventoryHandler.insertItem(SLOT_OUT, blockEntity.buffer.copy(), true).isEmpty()) {
                blockEntity.inventoryHandler.insertItem(SLOT_OUT, blockEntity.buffer.copy(), false);
                blockEntity.buffer = ItemStack.EMPTY;
            } else if (!log.isEmpty() && (output.isEmpty() || output.getCount() < output.getMaxStackSize())) {
                int speedModifier = 1 + blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()) + blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2;
                blockEntity.progress += blockEntity.tickRate * speedModifier;
                if (blockEntity.progress >= blockEntity.recipeTime) {
                    RecipeHolder<SawmillRecipe> recipe = TreeUtil.getSawmillRecipe(level, log);
                    if (recipe != null) {
                        ItemStack leftOver = blockEntity.inventoryHandler.insertItem(SLOT_OUT, ((SawmillRecipe)recipe.value()).output().copy(), false);
                        if (!leftOver.isEmpty()) {
                            blockEntity.buffer = leftOver;
                        }
                        if (!((SawmillRecipe)recipe.value()).secondary().isEmpty()) {
                            ItemStack tLeftover = blockEntity.inventoryHandler.insertItem(SLOT_SECONDARY, ((SawmillRecipe)recipe.value()).secondary().copy(), false);
                            if (!((SawmillRecipe)recipe.value()).tertiary().isEmpty()) {
                                blockEntity.inventoryHandler.insertItem(SLOT_TERTIARY, ((SawmillRecipe)recipe.value()).tertiary().copy(), false);
                            } else if (!tLeftover.isEmpty()) {
                                blockEntity.inventoryHandler.insertItem(SLOT_TERTIARY, tLeftover, false);
                            }
                        }
                        log.shrink(1);
                    }
                    blockEntity.progress = 0;
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new SawmillContainer(windowId, playerInventory, this);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        this.progress = tag.getInt("RecipeProgress");
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("RecipeProgress", this.progress);
    }
}

