/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class StorageSoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static final Map<UUID, SoundInstance> storageSounds = new ConcurrentHashMap<UUID, SoundInstance>();
    private static long lastPlaybackChecked = 0L;

    private StorageSoundHandler() {
    }

    public static void playStorageSound(UUID storageUuid, SoundInstance sound) {
        StorageSoundHandler.stopStorageSound(storageUuid);
        storageSounds.put(storageUuid, sound);
        Minecraft.getInstance().getSoundManager().play(sound);
    }

    public static void stopStorageSound(UUID storageUuid) {
        if (storageSounds.containsKey(storageUuid)) {
            Minecraft.getInstance().getSoundManager().stop(storageSounds.remove(storageUuid));
        }
    }

    public static void tick(LevelTickEvent.Post event) {
        if (!storageSounds.isEmpty() && lastPlaybackChecked < event.getLevel().getGameTime() - 10L) {
            lastPlaybackChecked = event.getLevel().getGameTime();
            storageSounds.entrySet().removeIf(entry -> !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)entry.getValue()));
        }
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, BlockPos pos) {
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)SimpleSoundInstance.forJukeboxSong((SoundEvent)soundEvent, (Vec3)Vec3.atCenterOf((Vec3i)pos)));
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        final Entity entity = level.getEntity(entityId);
        if (!(entity instanceof Entity)) {
            StorageSoundHandler.stopStorageSound(storageUuid);
            return;
        }
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)new EntityBoundSoundInstance(soundEvent, SoundSource.RECORDS, 2.0f, 1.0f, entity, level.random.nextLong()){

            public void tick() {
                super.tick();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    Vec3 lookAngle = player.getLookAngle();
                    this.x = player.getX() + lookAngle.x;
                    this.y = player.getEyeY() + lookAngle.y;
                    this.z = player.getZ() + lookAngle.z;
                }
            }
        });
    }

    public static void onWorldUnload(LevelEvent.Unload evt) {
        storageSounds.clear();
        lastPlaybackChecked = 0L;
    }
}

