/*
 * Decompiled with CFR 0.152.
 */
package pkgbadges.item;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import pkgbadges.init.PkgbadgesModItems;
import pkgbadges.world.inventory.RocketTeamBoxGuiMenu;

public class RocketTeamBoxItem
extends Item {
    public RocketTeamBoxItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    public InteractionResultHolder<ItemStack> use(Level world, final Player entity, final InteractionHand hand) {
        ItemStack stack = entity.getItemInHand(hand);
        if (!entity.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!world.isClientSide()) {
                int currentValue = (Integer)stack.getOrDefault(PkgbadgesModItems.CUSTOM_MODEL_DATA.get(), (Object)0);
                int newValue = currentValue == 0 ? 1 : 0;
                stack.set(PkgbadgesModItems.CUSTOM_MODEL_DATA.get(), (Object)newValue);
            }
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        if (entity.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && !world.isClientSide()) {
            int currentValue = (Integer)stack.getOrDefault(PkgbadgesModItems.CUSTOM_MODEL_DATA.get(), (Object)0);
            if (currentValue == 1 && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.literal((String)"Backpack");
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.writeBlockPos(entity.blockPosition());
                        packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                        return new RocketTeamBoxGuiMenu(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.writeBlockPos(entity.blockPosition());
                    buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                });
            } else {
                entity.displayClientMessage((Component)Component.literal((String)"Badge Box Not Opened!"), true);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

